<?php

class ScanDir
{
    const ALL = 1;

    const FILES = 2;

    const DIRECTORIES = 3;

    protected static function read($dir, $type = self::ALL)
    {
        $files = [];
        foreach (scandir($dir) as $file) {
            if ($file === '.' || $file === '..') {
                continue;
            }
            if (is_link($dir.'/'.$file)) {
                continue;
            }
            if (is_file($dir.'/'.$file) && $type == self::DIRECTORIES) {
                continue;
            }
            if (is_dir($dir.'/'.$file) && $type == self::FILES) {
                continue;
            }
            $files[$dir.'/'.$file] = filemtime($dir.'/'.$file);
        }

        asort($files);
        $files = array_keys($files);

        return ($files) ? $files : false;
    }

    public static function all($dir)
    {
        return static::read($dir, self::ALL);
    }

    public static function files($dir)
    {
        return static::read($dir, self::FILES);
    }

    public static function directories($dir)
    {
        return static::read($dir, self::DIRECTORIES);
    }
}

// echo implode("\n",ScanDir::read(".", ScanDir::ALL));
// echo implode("\n",ScanDir::read(".", ScanDir::DIRECTORIES));
// echo implode("\n",ScanDir::read(".", ScanDir::FILES));
