<?php

namespace Tests;

use App\Data\AddressData;
use App\Data\CustomerData;
use App\Data\FinancialLineData;
use App\Data\SalesOrderLineData;
use App\Data\SupplierInventoryData;
use App\Data\SupplierProductData;
use App\DTO\PaymentDto;
use App\DTO\ProductAttributeDto;
use App\DTO\ProductBrandDto;
use App\DTO\ProductDto;
use App\DTO\ProductImageDto;
use App\DTO\ProductListingDto;
use App\DTO\ProductPricingDto;
use App\DTO\ReportingDailyFinancialDto;
use App\DTO\SalesOrderDto;
use App\DTO\SalesOrderLineFinancialDto;
use App\DTO\SupplierDTO;
use App\DTO\WarehouseDto;
use App\Enums\FinancialLineProrationStrategyEnum;
use App\Models\Attribute;
use App\Models\Currency;
use App\Models\FinancialLineType;
use App\Models\PaymentType;
use App\Models\Product;
use App\Models\ProductListing;
use App\Models\ProductPricingTier;
use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Models\SalesOrderLine;
use App\Models\SalesOrderLineFinancial;
use App\Models\Supplier;
use App\Models\Warehouse;
use Carbon\Carbon;
use Modules\Amazon\Data\AmazonReportData;

class UpsertTestingData
{
    public static function addressData(): array
    {
        return [
            AddressData::from([
                'name' => 'Test Name',
                'email' => 'test@email.com',
                'city' => 'City',
                'country' => 'Country',
                'label' => 'Test Label2',
            ]),
            AddressData::from([
                'name' => 'Test Name 2',
                'email' => 'test2@email.com',
                'city' => 'City2',
                'country' => 'Country2',
                'label' => 'Test Label 2',
            ])
        ];
    }

    public static function customerData(): array
    {
        return [
            CustomerData::from([
                'name' => 'Test Name',
                'email' => 'test@email.com',
            ]),
            CustomerData::from([
                'name' => 'Test Name 2',
                'email' => 'test2@email.com',
            ])
        ];
    }

    public static function financialLineData(): array
    {
        $salesOrder = SalesOrder::factory()->create();
        $financialLineType = FinancialLineType::factory()->create();
        return [
            FinancialLineData::from([
                'sales_order_id' => $salesOrder->id,
                'financial_line_type_id' => $financialLineType->id,
                'description' => 'Test Description',
                'quantity' => 1,
                'amount' => 50,
                'proration_strategy' => FinancialLineProrationStrategyEnum::REVENUE_BASED,
                'sales_channel_line_id' => null,
                'allocate_to_products' => false,
            ]),
            FinancialLineData::from([
                'sales_order_id' => $salesOrder->id,
                'financial_line_type_id' => $financialLineType->id,
                'description' => 'Test Description',
                'quantity' => 1,
                'amount' => 100,
                'proration_strategy' => FinancialLineProrationStrategyEnum::REVENUE_BASED,
                'sales_channel_line_id' => null,
                'allocate_to_products' => false,
            ])
        ];
    }

    public static function paymentData(): array
    {
        $salesOrder = SalesOrder::factory()->create();
        $paymentDate = now()->toDateString();
        $paymentType = PaymentType::first();
        $currency = Currency::first();
        return [
            PaymentDto::from([
                'link_type' => SalesOrder::class,
                'link_id' => $salesOrder->id,
                'payment_date' => $paymentDate,
                'payment_type_id' => $paymentType->id,
                'amount' => 50,
                'currency_id' => $currency->id,
                'currency_rate' => $currency->conversion,
            ]),
            PaymentDto::from([
                'link_type' => SalesOrder::class,
                'link_id' => $salesOrder->id,
                'payment_date' => $paymentDate,
                'payment_type_id' => $paymentType->id,
                'amount' => 100,
                'currency_id' => $currency->id,
                'currency_rate' => $currency->conversion,
            ])
        ];
    }

    public static function productAttributeData(): array
    {
        $product1 = Product::factory()->create();
        $product2 = Product::factory()->create();
        $attribute = Attribute::factory()->create();
        return [
            ProductAttributeDto::from([
                'product_id' => $product1->id,
                'attribute_id' => $attribute->id,
            ]),
            ProductAttributeDto::from([
                'product_id' => $product2->id,
                'attribute_id' => $attribute->id,
            ])
        ];
    }

    public static function productListingData(): array
    {
        $product = Product::factory()->create();
        $salesChannel = SalesChannel::factory()->create();
        return [
            ProductListingDto::from([
                'sales_channel_id' => $salesChannel->id,
                'sales_channel_listing_id' => 'unique1',
                'listing_sku' => 'sku1',
                'product_id' => $product->id,
                'document_id' => '1',
                'document_type' => 'document_type1',
            ]),
            ProductListingDto::from([
                'sales_channel_id' => $salesChannel->id,
                'sales_channel_listing_id' => 'unique2',
                'listing_sku' => 'sku2',
                'product_id' => $product->id,
                'document_id' => '2',
                'document_type' => 'document_type2',
            ]),
        ];
    }

    public static function productPricingData(): array
    {
        $product = Product::factory()->create();
        $productPricingTier1 = ProductPricingTier::factory()->create();
        $productPricingTier2 = ProductPricingTier::factory()->create();
        return [
            ProductPricingDto::from([
                'product_pricing_tier_id' => $productPricingTier1->id,
                'product_id' => $product->id,
            ]),
            ProductPricingDto::from([
                'product_pricing_tier_id' => $productPricingTier2->id,
                'product_id' => $product->id,
            ]),
        ];
    }
    public static function productData(): array
    {
        return [
            ProductDto::from([
                'sku' => 'sku1',
                'name' => 'sku1',
            ]),
            ProductDto::from([
                'sku' => 'sku2',
                'name' => 'sku2',
            ]),
        ];
    }

    public static function salesOrderLineFinancialData(): array
    {
        $salesOrderLine1 = SalesOrderLine::first();
        $salesOrderLine2 = SalesOrderLine::offset(1)->first();
        return [
            SalesOrderLineFinancialDto::from([
                'sales_order_line_id' => $salesOrderLine1->id,
            ]),
            SalesOrderLineFinancialDto::from([
                'sales_order_line_id' => $salesOrderLine2->id,
            ]),
        ];
    }

    public static function reportingDailyFinancialData(): array
    {
        $product1 = Product::factory()->create();
        $product2 = Product::factory()->create();
        return [
            ReportingDailyFinancialDto::from([
                'date' => Carbon::now()->toDateString(),
                'reportable_id' => $product1->id,
                'reportable_type' => Product::class,
            ]),
            ReportingDailyFinancialDto::from([
                'date' => Carbon::now()->toDateString(),
                'reportable_id' => $product2->id,
                'reportable_type' => Product::class,
            ]),
        ];
    }

    public static function salesOrderLineData(): array
    {
        $salesOrder = SalesOrder::factory()->create();
        $product = Product::factory()->create();
        $productListing = ProductListing::factory()->create([
            'product_id' => $product->id
            ]);
        return [
            SalesOrderLineData::from([
                'sales_order_id' => $salesOrder->id,
                'sales_channel_line_id' => 1,
                'product_listing_id' => $productListing->id,
                'product_id' => $product->id,
                'description' => 'test',
                'quantity' => 1,
                'amount' => 50,
                'warehouse_id' => 1,
                'is_product' => true,
                'nominal_code_id' => 1,
            ]),
            SalesOrderLineData::from([
                'sales_order_id' => $salesOrder->id,
                'sales_channel_line_id' => 1,
                'product_listing_id' => $productListing->id,
                'product_id' => $product->id,
                'description' => 'test 2',
                'quantity' => 1,
                'amount' => 50,
                'warehouse_id' => 1,
                'is_product' => true,
                'nominal_code_id' => 1,
            ]),
        ];
    }

    public static function supplierInventoryData(): array
    {
        $product1 = Product::factory()->create();
        $product2 = Product::factory()->create();
        $supplier = Supplier::first();
        $warehouse = Warehouse::factory()->create();
        return [
            SupplierInventoryData::from([
                'product_id' => $product1->id,
                'supplier_id' => $supplier->id,
                'warehouse_id' => $warehouse->id,
            ]),
            SupplierInventoryData::from([
                'product_id' => $product2->id,
                'supplier_id' => $supplier->id,
                'warehouse_id' => $warehouse->id,
            ]),
        ];
    }

    public static function supplierData(): array
    {
        return [
            SupplierDTO::from([
                'name' => 'supplier1',
            ]),
            SupplierDTO::from([
                'name' => 'suppliers2',
            ])
        ];
    }

    public static function supplierProductData(): array
    {
        $product1 = Product::factory()->create();
        $product2 = Product::factory()->create();
        return [
            SupplierProductData::from([
                'product_id' => $product1->id,
                'supplier_id' => 1,
            ]),
            SupplierProductData::from([
                'product_id' => $product2->id,
                'supplier_id' => 1,
            ]),
        ];
    }

    public static function amazonReportData(): array
    {
        return [
            AmazonReportData::from([
                'integration_instance_id' => '1',
                'reportId' => 'report1',
                'reportType' => 'reportType1',
            ]),
            AmazonReportData::from([
                'integration_instance_id' => '1',
                'reportId' => 'report2',
                'reportType' => 'reportType1',
            ]),
        ];
    }

    public static function salesOrderData(): array
    {
        return [
            SalesOrderDto::from([
                'sales_order_number' => 'sale1',
                'sales_channel_id' => 1,
                'order_date' => now()->toDateString(),
                'requested_shipping_method' => 'test',
                'order_status' => 'open',
                'sales_channel_order_type' => 'abc',
                'sales_channel_order_id' => '1',
                'currency_id' => 1,
                'currency_rate' => 1,
                'store_id' => 1,
            ]),
            SalesOrderDto::from([
                'sales_order_number' => 'sale2',
                'sales_channel_id' => 1,
                'order_date' => now()->toDateString(),
                'requested_shipping_method' => 'test',
                'order_status' => 'open',
                'sales_channel_order_type' => 'abc',
                'sales_channel_order_id' => '1',
                'currency_id' => 1,
                'currency_rate' => 1,
                'store_id' => 1,
            ]),
        ];
    }

    public static function productBrandData(): array
    {
        return [
            ProductBrandDto::from([
                'name' => 'brand1',
            ]),
            ProductBrandDto::from([
                'name' => 'brand2',
            ])
        ];
    }

    public static function productImageData(): array
    {
        $product = Product::factory()->create();
        return [
            ProductImageDto::from([
                'product_id' => $product->id,
                'url' => 'http://testimage1.jpg'
            ]),
            ProductImageDto::from([
                'product_id' => $product->id,
                'url' => 'http://testimage2.jpg'
            ])
        ];
    }

    public static function warehouseData(): array
    {
        return [
            WarehouseDto::from([
                'name' => 'test',
                'type' => 'direct',
                'dropship_enabled' => true,
            ]),
            WarehouseDto::from([
                'name' => 'test2',
                'type' => 'direct',
            ])
        ];
    }
}