<?php

namespace Tests\Unit\ShopifyOrders;

use App\Models\SalesChannel;
use App\Models\Shopify\ShopifyOrder;
use App\Services\Shopify\Orders\Actions\ShopifyDownloadOrder;
use Illuminate\Foundation\Testing\WithFaker;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class DownloadOrdersTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    public function testDownloadSeveralOrders(): void
    {
        $orders = file_get_contents(__DIR__.'/ordersDummy');
        $orders = json_decode($orders, 1);
        $integrationInstance = SalesChannel::where('id', 1)->first()->integrationInstance;
        $count = ShopifyOrder::count();
        ShopifyDownloadOrder::bulkSaveShopifyOrderToSkuDB($integrationInstance->id, $orders, 'test');
        $this->assertEquals(ShopifyOrder::count(), $count + 50);
    }

    public function testDownloadOrdersHaveDoubleQuotation(): void
    {
        $orders = file_get_contents(__DIR__.'/ordersWithValueHaveDoubleQuotation');
        $orders = json_decode($orders, 1);
        $integrationInstance = SalesChannel::where('id', 1)->first()->integrationInstance;
        $count = ShopifyOrder::count();
        ShopifyDownloadOrder::bulkSaveShopifyOrderToSkuDB($integrationInstance->id, $orders, 'test');
        $this->assertEquals(ShopifyOrder::count(), $count + 1);
    }
}
