<?php

namespace Tests\Unit\ShopifyOrders;

use App\Models\Shopify\ShopifyOrder;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class CachePaymentCostTest extends TestCase
{
    use FastRefreshDatabase;

    public function testCacheTransactionForPaypalGateway(): void
    {
        $transactions = '[{"id":"gid:\/\/shopify\/OrderTransaction\/5762952396873","kind":"SALE","order":{"id":"gid:\/\/shopify\/Order\/4624045768777"},"status":"SUCCESS","fees":[],"formattedGateway":"Pay Pal Express Checkout","gateway":"paypal","receipt":"{\"timestamp\"=>\"2022-11-30T22:10:27Z\", \"ack\"=>\"Success\", \"correlation_id\"=>\"5665c2565ef53\", \"version\"=>\"124\", \"build\"=>\"57888165\", \"token\"=>\"EC-8LB28077AH248891D\", \"transaction_id\"=>\"86A48869X4622050B\", \"parent_transaction_id\"=>nil, \"receipt_id\"=>nil, \"transaction_type\"=>\"cart\", \"payment_type\"=>\"instant\", \"payment_date\"=>\"2022-11-30T22:10:25Z\", \"gross_amount\"=>\"93.94\", \"gross_amount_currency_id\"=>\"AUD\", \"fee_amount\"=>\"1.99\", \"fee_amount_currency_id\"=>\"AUD\", \"tax_amount\"=>\"0.00\", \"tax_amount_currency_id\"=>\"AUD\", \"exchange_rate\"=>nil, \"payment_status\"=>\"Completed\", \"pending_reason\"=>\"none\", \"reason_code\"=>\"none\", \"protection_eligibility\"=>\"Eligible\", \"protection_eligibility_type\"=>\"ItemNotReceivedEligible,UnauthorizedPaymentEligible\", \"pay_pal_account_id\"=>\"customercare@curvy.com.au\", \"secure_merchant_account_id\"=>\"XYLA5S86XAXML\", \"billing_agreement_id\"=>\"B-7MT56425F3743893T\", \"success_page_redirect_requested\"=>\"false\", \"coupled_payment_info\"=>nil, \"Token\"=>\"EC-8LB28077AH248891D\", \"PaymentInfo\"=>{\"TransactionID\"=>\"86A48869X4622050B\", \"ParentTransactionID\"=>nil, \"ReceiptID\"=>nil, \"TransactionType\"=>\"cart\", \"PaymentType\"=>\"instant\", \"PaymentDate\"=>\"2022-11-30T22:10:25Z\", \"GrossAmount\"=>\"93.94\", \"FeeAmount\"=>\"1.99\", \"TaxAmount\"=>\"0.00\", \"ExchangeRate\"=>nil, \"PaymentStatus\"=>\"Completed\", \"PendingReason\"=>\"none\", \"ReasonCode\"=>\"none\", \"ProtectionEligibility\"=>\"Eligible\", \"ProtectionEligibilityType\"=>\"ItemNotReceivedEligible,UnauthorizedPaymentEligible\", \"SellerDetails\"=>{\"PayPalAccountID\"=>\"customercare@curvy.com.au\", \"SecureMerchantAccountID\"=>\"XYLA5S86XAXML\"}}, \"BillingAgreementID\"=>\"B-7MT56425F3743893T\", \"SuccessPageRedirectRequested\"=>\"false\", \"CoupledPaymentInfo\"=>nil}","processedAt":"2022-11-30T22:10:24Z","amount":"93.94","amountSet":{"presentmentMoney":{"amount":"93.94","currencyCode":"AUD"},"shopMoney":{"amount":"93.94","currencyCode":"AUD"}}}]';
        $transaction = json_decode($transactions, 1)[0];
        $cost = (new ShopifyOrder())->getTransactionCost($transaction);
        $this->assertEquals(1.99, $cost);
        $transactions = '[{"id": "gid:\/\/shopify\/OrderTransaction\/4770118991945", "kind": "SALE", "status": "SUCCESS", "processedAt": "2021-06-01T09:22:51Z", "fees": [], "formattedGateway": "Pay Pal Express Checkout", "gateway": "paypal", "receipt": "{\"timestamp\"=\u003e\"2021-06-01T09:22:54Z\", \"ack\"=\u003e\"Success\", \"correlation_id\"=\u003e\"f25ae6132d5d3\", \"version\"=\u003e\"124\", \"build\"=\u003e\"55644101\", \"token\"=\u003e\"EC-6EP0229024916992X\", \"transaction_id\"=\u003e\"2W474880AU3115827\", \"parent_transaction_id\"=\u003enil, \"receipt_id\"=\u003enil, \"transaction_type\"=\u003e\"cart\", \"payment_type\"=\u003e\"instant\", \"payment_date\"=\u003e\"2021-06-01T09:22:53Z\", \"gross_amount\"=\u003e\"189.90\", \"gross_amount_currency_id\"=\u003e\"AUD\", \"fee_amount\"=\u003e\"3.72\", \"fee_amount_currency_id\"=\u003e\"AUD\", \"tax_amount\"=\u003e\"0.00\", \"tax_amount_currency_id\"=\u003e\"AUD\", \"exchange_rate\"=\u003enil, \"payment_status\"=\u003e\"Completed\", \"pending_reason\"=\u003e\"none\", \"reason_code\"=\u003e\"none\", \"protection_eligibility\"=\u003e\"Eligible\", \"protection_eligibility_type\"=\u003e\"ItemNotReceivedEligible,UnauthorizedPaymentEligible\", \"pay_pal_account_id\"=\u003e\"customercare@curvy.com.au\", \"secure_merchant_account_id\"=\u003e\"XYLA5S86XAXML\", \"success_page_redirect_requested\"=\u003e\"false\", \"coupled_payment_info\"=\u003enil, \"Token\"=\u003e\"EC-6EP0229024916992X\", \"PaymentInfo\"=\u003e{\"TransactionID\"=\u003e\"2W474880AU3115827\", \"ParentTransactionID\"=\u003enil, \"ReceiptID\"=\u003enil, \"TransactionType\"=\u003e\"cart\", \"PaymentType\"=\u003e\"instant\", \"PaymentDate\"=\u003e\"2021-06-01T09:22:53Z\", \"GrossAmount\"=\u003e\"189.90\", \"FeeAmount\"=\u003e\"3.72\", \"TaxAmount\"=\u003e\"0.00\", \"ExchangeRate\"=\u003enil, \"PaymentStatus\"=\u003e\"Completed\", \"PendingReason\"=\u003e\"none\", \"ReasonCode\"=\u003e\"none\", \"ProtectionEligibility\"=\u003e\"Eligible\", \"ProtectionEligibilityType\"=\u003e\"ItemNotReceivedEligible,UnauthorizedPaymentEligible\", \"SellerDetails\"=\u003e{\"PayPalAccountID\"=\u003e\"customercare@curvy.com.au\", \"SecureMerchantAccountID\"=\u003e\"XYLA5S86XAXML\"}}, \"SuccessPageRedirectRequested\"=\u003e\"false\", \"CoupledPaymentInfo\"=\u003enil}", "amount": "189.90", "amountSet": {"presentmentMoney": {"amount": "189.9", "currencyCode": "AUD"}, "shopMoney": {"amount": "189.9", "currencyCode": "AUD"}}}]';
        $transaction = json_decode($transactions, 1)[0];
        $cost = (new ShopifyOrder())->getTransactionCost($transaction);
        $this->assertEquals(3.72, $cost);
    }

    public function testCacheTransactionForShopifyPaymentGateway(): void
    {
        $transactions = '[{"id": "gid:\/\/shopify\/OrderTransaction\/4733143482449", "kind": "SALE", "status": "SUCCESS", "processedAt": "2021-05-14T11:26:45Z", "fees": [{"amount": {"amount": "0.87", "currencyCode": "USD"}, "rateName": "domestic_card_not_present", "type": "processing_fee"}], "formattedGateway": "Shopify Payments", "gateway": "shopify_payments", "receipt": "{\"id\"=\u003e\"pi_1IqzAHEWXPRAkOarLJSu6e0P\", \"object\"=\u003e\"payment_intent\", \"amount\"=\u003e1980, \"amount_capturable\"=\u003e0, \"amount_received\"=\u003e1980, \"canceled_at\"=\u003enil, \"cancellation_reason\"=\u003enil, \"capture_method\"=\u003e\"automatic\", \"charges\"=\u003e{\"object\"=\u003e\"list\", \"data\"=\u003e[{\"id\"=\u003e\"ch_1IqzAIEWXPRAkOaruwFQ7Rrf\", \"object\"=\u003e\"charge\", \"amount\"=\u003e1980, \"application_fee\"=\u003e\"fee_1IqzAJEWXPRAkOar60Omoy5U\", \"balance_transaction\"=\u003e{\"id\"=\u003e\"txn_1IqzAJEWXPRAkOarxPA8DzHN\", \"object\"=\u003e\"balance_transaction\", \"exchange_rate\"=\u003enil}, \"captured\"=\u003etrue, \"created\"=\u003e1620991606, \"currency\"=\u003e\"usd\", \"failure_code\"=\u003enil, \"failure_message\"=\u003enil, \"fraud_details\"=\u003e{}, \"livemode\"=\u003etrue, \"metadata\"=\u003e{\"shop_id\"=\u003e\"13026953\", \"shop_name\"=\u003e\"Fuelpumps.com\", \"transaction_fee_total_amount\"=\u003e\"87\", \"transaction_fee_tax_amount\"=\u003e\"0\", \"payments_charge_id\"=\u003e\"1810764496977\", \"order_transaction_id\"=\u003e\"4733143482449\", \"manual_entry\"=\u003e\"false\", \"order_id\"=\u003e\"c20027151515729.1\", \"email\"=\u003e\"chrisdickeymotorsports@hotmail.com\"}, \"outcome\"=\u003e{\"network_status\"=\u003e\"approved_by_network\", \"reason\"=\u003enil, \"risk_level\"=\u003e\"normal\", \"seller_message\"=\u003e\"Payment complete.\", \"type\"=\u003e\"authorized\"}, \"paid\"=\u003etrue, \"payment_intent\"=\u003e\"pi_1IqzAHEWXPRAkOarLJSu6e0P\", \"payment_method\"=\u003e\"pm_1IqzAHEWXPRAkOar67KkXcwp\", \"payment_method_details\"=\u003e{\"card\"=\u003e{\"brand\"=\u003e\"visa\", \"checks\"=\u003e{\"address_line1_check\"=\u003e\"pass\", \"address_postal_code_check\"=\u003e\"pass\", \"cvc_check\"=\u003e\"pass\"}, \"country\"=\u003e\"US\", \"description\"=\u003e\"Visa Classic\", \"ds_transaction_id\"=\u003enil, \"exp_month\"=\u003e2, \"exp_year\"=\u003e2022, \"fingerprint\"=\u003e\"2f8MJk5s1q4yaKKx\", \"funding\"=\u003e\"debit\", \"iin\"=\u003e\"429154\", \"installments\"=\u003enil, \"issuer\"=\u003e\"Financial Center First Credit Union\", \"last4\"=\u003e\"8946\", \"moto\"=\u003enil, \"network\"=\u003e\"visa\", \"network_transaction_id\"=\u003e\"381134412079702\", \"three_d_secure\"=\u003enil, \"wallet\"=\u003enil}, \"type\"=\u003e\"card\"}, \"refunded\"=\u003efalse, \"source\"=\u003enil, \"status\"=\u003e\"succeeded\", \"mit_params\"=\u003e{\"network_transaction_id\"=\u003e\"381134412079702\"}}], \"has_more\"=\u003efalse, \"total_count\"=\u003e1, \"url\"=\u003e\"\/v1\/charges?payment_intent=pi_1IqzAHEWXPRAkOarLJSu6e0P\"}, \"confirmation_method\"=\u003e\"manual\", \"created\"=\u003e1620991605, \"currency\"=\u003e\"usd\", \"last_payment_error\"=\u003enil, \"livemode\"=\u003etrue, \"metadata\"=\u003e{\"shop_id\"=\u003e\"13026953\", \"shop_name\"=\u003e\"Fuelpumps.com\", \"transaction_fee_total_amount\"=\u003e\"87\", \"transaction_fee_tax_amount\"=\u003e\"0\", \"payments_charge_id\"=\u003e\"1810764496977\", \"order_transaction_id\"=\u003e\"4733143482449\", \"manual_entry\"=\u003e\"false\", \"order_id\"=\u003e\"c20027151515729.1\", \"email\"=\u003e\"chrisdickeymotorsports@hotmail.com\"}, \"next_action\"=\u003enil, \"payment_method\"=\u003e\"pm_1IqzAHEWXPRAkOar67KkXcwp\", \"payment_method_types\"=\u003e[\"card\"], \"source\"=\u003enil, \"status\"=\u003e\"succeeded\"}", "amount": "19.80", "amountSet": {"presentmentMoney": {"amount": "19.8", "currencyCode": "USD"}, "shopMoney": {"amount": "19.8", "currencyCode": "USD"}}}]';
        $transaction = json_decode($transactions, 1)[0];
        $cost = (new ShopifyOrder())->getTransactionCost($transaction);
        $this->assertEquals(0.87, $cost);
        $transactions = '[{"id": "gid:\/\/shopify\/OrderTransaction\/4742879019089", "kind": "SALE", "status": "SUCCESS", "processedAt": "2021-05-19T16:08:40Z", "fees": [{"amount": {"amount": "3.35", "currencyCode": "USD"}, "rateName": "domestic_card_not_present", "type": "processing_fee"}], "formattedGateway": "Shopify Payments", "gateway": "shopify_payments", "receipt": "{\"id\"=\u003e\"pi_1IsrwqEWXPRAkOarc0dYCwTM\", \"object\"=\u003e\"payment_intent\", \"amount\"=\u003e10500, \"amount_capturable\"=\u003e0, \"amount_received\"=\u003e10500, \"canceled_at\"=\u003enil, \"cancellation_reason\"=\u003enil, \"capture_method\"=\u003e\"automatic\", \"charges\"=\u003e{\"object\"=\u003e\"list\", \"data\"=\u003e[{\"id\"=\u003e\"ch_1IsrwrEWXPRAkOarjNQTTisO\", \"object\"=\u003e\"charge\", \"amount\"=\u003e10500, \"application_fee\"=\u003e\"fee_1IsrwsEWXPRAkOarDwOqLt1O\", \"balance_transaction\"=\u003e{\"id\"=\u003e\"txn_1IsrwsEWXPRAkOarg1nvOpqV\", \"object\"=\u003e\"balance_transaction\", \"exchange_rate\"=\u003enil}, \"captured\"=\u003etrue, \"created\"=\u003e1621440521, \"currency\"=\u003e\"usd\", \"failure_code\"=\u003enil, \"failure_message\"=\u003enil, \"fraud_details\"=\u003e{}, \"livemode\"=\u003etrue, \"metadata\"=\u003e{\"shop_id\"=\u003e\"13026953\", \"shop_name\"=\u003e\"Fuelpumps.com\", \"transaction_fee_total_amount\"=\u003e\"335\", \"transaction_fee_tax_amount\"=\u003e\"0\", \"payments_charge_id\"=\u003e\"1814439329873\", \"order_transaction_id\"=\u003e\"4742879019089\", \"manual_entry\"=\u003e\"false\", \"order_id\"=\u003e\"c20047803056209.1\", \"email\"=\u003e\"koultools@gmail.com\"}, \"outcome\"=\u003e{\"network_status\"=\u003e\"approved_by_network\", \"reason\"=\u003enil, \"risk_level\"=\u003e\"normal\", \"seller_message\"=\u003e\"Payment complete.\", \"type\"=\u003e\"authorized\"}, \"paid\"=\u003etrue, \"payment_intent\"=\u003e\"pi_1IsrwqEWXPRAkOarc0dYCwTM\", \"payment_method\"=\u003e\"pm_1IsrwqEWXPRAkOarMPv6eXeh\", \"payment_method_details\"=\u003e{\"card\"=\u003e{\"brand\"=\u003e\"mastercard\", \"checks\"=\u003e{\"address_line1_check\"=\u003e\"pass\", \"address_postal_code_check\"=\u003e\"pass\", \"cvc_check\"=\u003e\"pass\"}, \"country\"=\u003e\"US\", \"description\"=\u003e\"MasterCard BusinessCard Card\", \"ds_transaction_id\"=\u003enil, \"exp_month\"=\u003e10, \"exp_year\"=\u003e2024, \"fingerprint\"=\u003e\"dhEmV36oGSJypHnp\", \"funding\"=\u003e\"credit\", \"iin\"=\u003e\"552851\", \"installments\"=\u003enil, \"issuer\"=\u003e\"CAPITAL ONE BANK (USA), NATIONAL ASSOCIATION\", \"last4\"=\u003e\"6653\", \"moto\"=\u003enil, \"network\"=\u003e\"mastercard\", \"network_transaction_id\"=\u003e\"MPCBBEQH60519\", \"three_d_secure\"=\u003enil, \"wallet\"=\u003enil}, \"type\"=\u003e\"card\"}, \"refunded\"=\u003efalse, \"source\"=\u003enil, \"status\"=\u003e\"succeeded\", \"mit_params\"=\u003e{\"network_transaction_id\"=\u003e\"MPCBBEQH60519\"}}], \"has_more\"=\u003efalse, \"total_count\"=\u003e1, \"url\"=\u003e\"\/v1\/charges?payment_intent=pi_1IsrwqEWXPRAkOarc0dYCwTM\"}, \"confirmation_method\"=\u003e\"manual\", \"created\"=\u003e1621440520, \"currency\"=\u003e\"usd\", \"last_payment_error\"=\u003enil, \"livemode\"=\u003etrue, \"metadata\"=\u003e{\"shop_id\"=\u003e\"13026953\", \"shop_name\"=\u003e\"Fuelpumps.com\", \"transaction_fee_total_amount\"=\u003e\"335\", \"transaction_fee_tax_amount\"=\u003e\"0\", \"payments_charge_id\"=\u003e\"1814439329873\", \"order_transaction_id\"=\u003e\"4742879019089\", \"manual_entry\"=\u003e\"false\", \"order_id\"=\u003e\"c20047803056209.1\", \"email\"=\u003e\"koultools@gmail.com\"}, \"next_action\"=\u003enil, \"payment_method\"=\u003e\"pm_1IsrwqEWXPRAkOarMPv6eXeh\", \"payment_method_types\"=\u003e[\"card\"], \"source\"=\u003enil, \"status\"=\u003e\"succeeded\"}", "amount": "105.00", "amountSet": {"presentmentMoney": {"amount": "105.0", "currencyCode": "USD"}, "shopMoney": {"amount": "105.0", "currencyCode": "USD"}}}]';
        $transaction = json_decode($transactions, 1)[0];
        $cost = (new ShopifyOrder())->getTransactionCost($transaction);

        $this->assertEquals(3.35, $cost);
    }

    public function testCacheTransactionForElseGateway(): void
    {
        $transactions = '[{"id": "gid:\/\/shopify\/OrderTransaction\/4795601453129", "kind": "SALE", "status": "SUCCESS", "processedAt": "2021-06-14T15:10:51Z", "fees": [], "formattedGateway": "Afterpay", "gateway": "afterpay", "receipt": "{\"x_timestamp\"=\u003e\"2021-06-14T15:10:50Z\", \"x_signature\"=\u003e\"4e2d7856e5a901c67d326d11a259ae039f94b1c6388a9a66eceac063fb05c089\", \"x_reference\"=\u003e\"21777945231433\", \"x_account_id\"=\u003e\"35223\", \"x_currency\"=\u003e\"AUD\", \"x_amount\"=\u003e\"55.47\", \"x_result\"=\u003e\"completed\", \"x_gateway_reference\"=\u003e\"afterpay:189612330\", \"x_test\"=\u003e\"false\"}", "amount": "55.47", "amountSet": {"presentmentMoney": {"amount": "55.47", "currencyCode": "AUD"}, "shopMoney": {"amount": "55.47", "currencyCode": "AUD"}}}]';
        $transaction = json_decode($transactions, 1)[0];
        $cost = (new ShopifyOrder())->getTransactionCost($transaction);
        $this->assertEquals(null, $cost);
    }
}
