<?php

namespace Tests;

use Database\Seeders\TestDatabaseSeeder;
use Http;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;

class TestCase extends BaseTestCase
{
    use CreatesApplication;

    protected string $seeder = TestDatabaseSeeder::class;

    protected bool $seed = true;

    protected function clearExistingFakes(): static
    {
        $reflection = new \ReflectionObject(Http::getFacadeRoot());
        $property = $reflection->getProperty('stubCallbacks');
        $property->setAccessible(true);
        $property->setValue(Http::getFacadeRoot(), collect());

        return $this;
    }
}
