<?php

namespace Tests\Support;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ShipstationTest extends TestCase
{
    use WithFaker;
    use FastRefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        Queue::fake();

        Sanctum::actingAs(User::factory()->create(['is_power_user' => true]));

        $integration = Integration::query()->whereName(Integration::NAME_SHIPSTATION)->first();

        // Create the Shipstation integration
        IntegrationInstance::factory()->create([
            'name' => Integration::NAME_SHIPSTATION,
            'connection_settings' => [
                'apiKey' => '296cd462172b4943b3bc9fe8b891188a', //$this->faker->md5(),
                'apiSecret' => '10a3db15ea4546b6a487b46badb4f104', //$this->faker->sha1()
            ],
            'integration_id' => $integration ? $integration->id : Integration::factory()->create([
                'name' => Integration::NAME_SHIPSTATION,
                'integration_type' => Integration::TYPE_SHIPPING_PROVIDER
            ]),
        ]);

        // Ensure that all external api requests are mocked.
        Http::preventStrayRequests();

    }

    protected function mockEndpoint(string $endpoint, array $response = [], array $headers = []){
        $endpoint = ltrim($endpoint, '/');

        Http::fake([
            "ssapi.shipstation.com/$endpoint" => Http::response(
                body: json_encode($response),
                headers: $headers + [
                    'X-DayLimit-Remaining' => 100
                ]
            )
        ]);
    }
}
