<?php

namespace Tests;

use Illuminate\Contracts\Console\Kernel;
use Illuminate\Foundation\Testing\RefreshDatabaseState;
use JsonException;
use Plannr\Laravel\FastRefreshDatabase\Data\FastRefreshDatabaseState;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;

/**
 * This trait truncates or refreshes the database
 * based on the setting in testing.database.refresh_action
 *
 * NOTE: This is only available for mysql now.
 */
trait RefreshDatabase
{
    use FastRefreshDatabase {
        FastRefreshDatabase::refreshTestDatabase as fastRefreshDatabase;
    }

    /**
     * @throws JsonException
     */
    protected function refreshTestDatabase(): void
    {
        if (! RefreshDatabaseState::$migrated) {
            $cachedChecksum = FastRefreshDatabaseState::$cachedChecksum ??= $this->getCachedMigrationChecksum();
            $currentChecksum = FastRefreshDatabaseState::$currentChecksum ??= $this->calculateMigrationChecksum();

            if ($cachedChecksum !== $currentChecksum) {
                $this->artisan('migrate:fresh', $this->migrateFreshUsing());

                $this->app[Kernel::class]->setArtisan(null);

                $this->storeMigrationChecksum($currentChecksum);
            } elseif ($this->seed) {
                // Run seeders
                $this->artisan('db:seed', ['--class' => $this->seeder]);
            }

            RefreshDatabaseState::$migrated = true;
        }

        if ($this->withTransactions) {
            $this->beginDatabaseTransaction();
        }

        deleteAllTemporaryTables();
    }
}
