<?php

namespace Tests\Feature;

use App\Models\Supplier;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Modules\Xero\DTO\XeroContact;
use Modules\Xero\Tests\XeroTest;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;

class XeroContactControllerTest extends XeroTest
{
    use FastRefreshDatabase;

    public function test_it_can_sync_suppliers(): void
    {
        /** @var Supplier $supplier */
        $supplier = Supplier::query()->first();

        $this->mockConnectionRequests();
        $this->mockEndpoint(
            endpoint: '/Contacts?*',
            response: [
                'Contacts' => [
                    XeroContact::from([
                        'StatusAttributeString' => 'OK',
                        'json_object' => [
                            'ContactID' => $this->faker->sha1(),
                            'Name' => $supplier->name,
                        ],
                    ]),
                ],
            ]
        );

        $this->postJson('/api/xero/contacts/sync')
            ->assertSuccessful();

        $this->assertDatabaseCount('xero_contacts', 1);
        $this->assertDatabaseHas('xero_contacts', [
            'link_type' => Supplier::class,
            'link_id' => $supplier->id,
        ]);
    }
}
