<?php

namespace Tests\Feature;

use App\Integrations\Shopify;
use Tests\TestCase;
use Tests\TestCaseOld;

class ShopifyOrderTransactionsTest extends TestCase
{
    public function test_graphql_time_to_retry_is_correct(): void
    {
        $shopify = $this->partialMock(Shopify::class);
        $shopify->shouldReceive('getOrderTransactions')->andReturn([
            'extensions' => [
                'cost' => [
                    'requestedQueryCost' => 5,
                    'actualQueryCost' => 205,
                    'throttleStatus' => [
                        'maximumAvailable' => 1000,
                        'currentlyAvailable' => 100,
                        'restoreRate' => 100,
                    ],
                ],
            ],
        ]

        );

        $data = $shopify->getOrderTransactions(1);
        $rate = Shopify::getGraphqlTimeToRetry($data['extensions']['cost']);
        $this->assertEquals(2, $rate);
    }
}
