<?php

namespace Tests\Feature;

use App\Exceptions\ProductBundleException;
use App\Exceptions\SalesOrder\InvalidProductWarehouseRouting;
use App\Models\Product;
use App\Models\SalesOrder;
use App\Models\Setting;
use App\Models\Warehouse;
use App\Repositories\SettingRepository;
use App\Services\SalesOrder\SalesOrderManager;
use App\Services\SalesOrder\WarehouseRoutingMethod;
use Carbon\Carbon;
use Illuminate\Support\Facades\Queue;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;
use Tests\TestCaseOld;
use Throwable;

class ShipStationManagerTest extends TestCase
{
    use FastRefreshDatabase;

    /**
     * @throws ProductBundleException
     * @throws InvalidProductWarehouseRouting
     * @throws Throwable
     */
    public function test_it_can_determine_bundle_split_from_setting()
    {
        $this->markTestSkipped('This functionality may no longer be desired');
        Queue::fake();
        /*
         * Create sales order with stock
         *
         * Set bundle split to true
         * Fulfill with ShipStation
         * Assert bundle was split in shipstation payload
         *
         * Set bundle split to false
         * Fulfill with ShipStation
         * Assert bundle was not split in shipstation payload
         *
         */

        app(SettingRepository::class)->set(Setting::KEY_SO_SHIPPING_PROVIDER_SPLIT_BUNDLES, true);

        $warehouse = Warehouse::factory()->create();

        $bundle = Product::factory()->create([
            'sku' => 'BUNDLE-1',
            'name' => 'Bundle 1',
            'type' => Product::TYPE_BUNDLE,
        ]);

        $component1 = Product::factory()->create([
            'sku' => 'COMPONENT-1',
            'name' => 'Component 1',
            'type' => Product::TYPE_STANDARD,
        ]);

        $component2 = Product::factory()->create([
            'sku' => 'COMPONENT-2',
            'name' => 'Component 2',
            'type' => Product::TYPE_STANDARD,
        ]);

        $bundle->setBundleComponents([
            [
                'id' => $component1->id,
                'quantity' => 2,
            ],
            [
                'id' => $component2->id,
                'quantity' => 3,
            ],
        ]);

        $component1->setInitialInventory($warehouse->id, 100, 5.00);
        $component2->setInitialInventory($warehouse->id, 100, 5.00);

        app(SalesOrderManager::class)->createOrder([
            'currency_code' => 'USD',
            'order_date' => Carbon::now()->toDateTimeString(),
            'order_status' => SalesOrder::STATUS_OPEN,
            'sales_order_lines' => [
                [
                    'product_id' => $bundle->id,
                    'quantity' => 2,
                    'amount' => 100,
                    'warehouse_routing_method' => WarehouseRoutingMethod::WAREHOUSE->value,
                    'warehouse_id' => $warehouse->id,
                ],
            ],
        ]);

        $this->assertTrue(true);
    }
}
