<?php

namespace Tests\Feature;

use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use App\Models\User;
use Illuminate\Support\Facades\Event;
use Laravel\Sanctum\HasApiTokens;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class PurchaseOrderActivityTest extends TestCase
{
    use FastRefreshDatabase;

    /**
     * A basic feature test example.
     */
    public function test_it_can_record_purchase_order_activity_including_lines(): void
    {
        $this->markTestSkipped(message: 'Purchase order factory is problematic');
        $this->setUser();

        $purchaseOrder = PurchaseOrder::factory()->create();

        $response = $this->getJson('/api/purchase-orders', $purchaseOrder->toArray());

        $response->assertSuccessful();
    }

    public function test_it_can_filter_purchase_order_activity_including_lines_by_subject(): void
    {
        $this->markTestSkipped(message: 'Purchase order factory is problematic');
        Event::fake();
        $this->setUser();
        $purchaseOrder = PurchaseOrder::factory()->has(PurchaseOrderLine::factory()->count(2))->create();
        $response = $this->getJson("/api/activity?filter[subject]=App\\Models\\PurchaseOrder:$purchaseOrder->id");
        $response->assertStatus(200);
        $response->assertJsonFragment([
            'parent_subject_id' => $purchaseOrder->id,
            'subject_type' => \App\Models\PurchaseOrder::class,

        ]);
        $response->assertJsonFragment([
            'parent_subject_id' => $purchaseOrder->id,
            'subject_type' => \App\Models\PurchaseOrderLine::class,
        ]);
    }

    protected function setUser()
    {
        /** @var HasApiTokens $user */
        $user = User::factory()->create();
        Sanctum::actingAs($user);
    }
}
