<?php

namespace Tests\Feature;

use App\DTO\ProductAttributeDto;
use App\DTO\ProductBrandDto;
use App\DTO\ProductDto;
use App\DTO\ProductImageDto;
use App\DTO\ProductPricingDto;
use App\DTO\SupplierDTO;
use App\Models\Attribute;
use App\Models\Product;
use App\Models\ProductAttribute;
use App\Models\ProductBrand;
use App\Models\ProductImage;
use App\Models\ProductPricing;
use App\Models\ProductPricingTier;
use App\Models\Supplier;
use App\Models\SupplierInventory;
use App\Models\SupplierProduct;
use App\Models\SupplierWarehouse;
use App\Repositories\ProductRepository;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ProductRepositoryTest extends TestCase
{
    use FastRefreshDatabase;

    public function testProductNewSaveBulk()
    {
        $repository = app(ProductRepository::class);

        $colorAttribute = Attribute::factory()->create([
            'name' => 'color',
        ]);

        $data = ProductDto::collection([
            ProductDto::from([
                'sku' => 'sku1',
                'name' => 'name1',
                'type' => 'standard',
                'product_brand' => ProductBrandDto::from([
                    'name' => 'brand1',
                ]),
                'supplier' => SupplierDTO::from([
                    'name' => 'supplier1',
                ]),
                'images' => ProductImageDto::collection([
                    ProductImageDto::from([
                        'url' => 'image1',
                    ]),
                    ProductImageDto::from([
                        'url' => 'image2',
                    ]),
                ]),
                'pricing' => ProductPricingDto::collection([
                    ProductPricingDto::from([
                        'product_pricing_tier_id' => ProductPricingTier::default()->id,
                        'price' => 30,
                    ]),
                ]),
            ]),
            ProductDto::from([
                'sku' => 'sku2',
                'name' => 'name2',
                'type' => 'standard',
                'product_brand' => ProductBrandDto::from([
                    'name' => 'brand2',
                ]),
                'images' => ProductImageDto::collection([
                    ProductImageDto::from([
                        'url' => 'image3',
                    ]),
                ]),
                'pricing' => ProductPricingDto::collection([
                    ProductPricingDto::from([
                        'product_pricing_tier_id' => ProductPricingTier::default()->id,
                        'price' => 20,
                    ]),
                ]),
            ]),
            ProductDto::from([
                'sku' => 'sku3',
                'name' => 'name3',
                'type' => 'standard',
                'pricing' => ProductPricingDto::collection([
                    ProductPricingDto::from([
                        'product_pricing_tier_id' => ProductPricingTier::default()->id,
                        'price' => 10,
                    ]),
                ]),
                'attributes' => ProductAttributeDto::collection([
                    ProductAttributeDto::from([
                        'attribute_id' => $colorAttribute->id,
                        'value' => 'red',
                    ]),
                ]),
            ]),
        ]);

        $repository->saveWithRelations($data);

        $this->assertDatabaseHas((new ProductBrand())->getTable(), [
            'name' => 'brand1',
        ]);
        $this->assertDatabaseCount((new ProductBrand())->getTable(), 2);

        $this->assertDatabaseHas((new Supplier())->getTable(), [
            'name' => 'supplier1',
        ]);
        // Including default supplier
        $this->assertDatabaseCount((new Supplier())->getTable(), 2);

        $this->assertDatabaseHas((new SupplierWarehouse())->getTable(), [
            'name' => 'Main Warehouse',
            'supplier_id' => Supplier::where('name', 'supplier1')->first()->id,
        ]);
        // Including default supplier and default warehouse
        $this->assertDatabaseCount((new SupplierWarehouse())->getTable(), 3);

        $this->assertDatabaseCount((new Product())->getTable(), 3);
        $this->assertDatabaseCount((new SupplierProduct())->getTable(), 1);
        $this->assertDatabaseCount((new SupplierInventory())->getTable(), 1);
        $this->assertDatabaseCount((new ProductImage())->getTable(), 3);
        $this->assertDatabaseCount((new ProductPricing())->getTable(), 3);
        $this->assertDatabaseCount((new ProductAttribute())->getTable(), 1);
    }
}
