<?php

namespace Tests\Feature;

use App\Models\Product;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Sanctum\Sanctum;
use League\Csv\Reader;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ProductExportTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    public function test_it_can_export_product_tags_in_correct_format(): void
    {
        $tag1 = 'tag 1';
        $tag2 = 'tag 2';

        Product::factory()->create([
            'sku' => 'ABC',
            'tags' => [$tag1, $tag2],
        ]);

        $this->actingAs(User::factory()->create());

        $this->assertDatabaseHas((new Product())->getTable(), [
            'sku' => 'ABC',
        ]);

        $response = $this->get('/export/products?included=["sku","tags"]')->assertSuccessful();

        $response->assertDownload();
        $response->assertHeader('Content-Disposition');

        $file = $response->getFile();
        //$contents = str_getcsv(file_get_contents($file->getPathname()), "\n");
        $csv = Reader::createFromPath($file->getPathname());

        $csv->setHeaderOffset(0);
        $records = $csv->getRecords();
        $records->rewind();

        $record = $records->current();

        $this->assertEquals('ABC', $record['sku']);
        $this->assertEquals('tag 1|tag 2', $record['tags']);
    }
}
