<?php

namespace Tests\Feature\Patches;

use App\Console\Commands\Patches\FixDuplicateWarehousesCommand;
use App\Models\Supplier;
use App\Models\Warehouse;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

/**
 * @group manual
 *
 * Not to be run on deploy
 */
class FixDuplicateWarehousesTest extends TestCase
{
    use FastRefreshDatabase;

    public function test_it_can_fix_duplicate_warehouses()
    {
        Supplier::factory(2)
            ->hasWarehouses(1, [
                'name' => 'Main Warehouse',
            ])
            ->create([
                'default_warehouse_id' => null,
            ]);

        // 2 newly created + 1 from seeder for default supplier warehouse
        $this->assertEquals(3, Warehouse::where('name', 'Main Warehouse')->count());

        $this->artisan('patch:fix-duplicate-warehouses');

        $this->assertEquals(0, Warehouse::where('name', 'Main Warehouse')->count());

    }
}
