<?php

namespace Tests\Feature\Controllers;

use App\Helpers;
use App\Models\Product;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use App\Models\TrackedJobLog;
use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Laravel\Sanctum\Sanctum;
use Tests\TestCase;

class TableViewControllerTest extends TestCase
{
    use DatabaseTransactions;

    public function test_it_can_display_data_for_tracked_job_table(): void
    {
        $qty = 5;

        Sanctum::actingAs(User::first());

        TrackedJobLog::factory($qty)->create();

        $response = $this->getJson(
            route('table-views.index').'?'.Helpers::simpleFilter('model', 'tracked-job-log')
        );

        $response->assertOk();

        $this->assertGreaterThanOrEqual($qty, $response->json()['data']);
    }
}
