<?php

namespace Tests\Feature\Controllers;

use App\Models\PurchaseOrder;
use App\Models\SalesOrder;
use App\Models\StoreEmailTemplate;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class StoreEmailTemplateControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    protected function setUp(): void
    {
        parent::setUp();
        Sanctum::actingAs(User::first());
    }

    public function test_user_can_list_non_system_sales_order_templates(): void
    {
        StoreEmailTemplate::factory()->count(5)->create([
            'type' => StoreEmailTemplate::TYPE_CONTEXT_SALES_ORDER,
            'is_system_template' => false
        ]);

        $response = $this->getJson(route('store-email-templates.user-templates'))->assertOk();

        $this->assertCount(5, $response->json('data'));
    }

    public function test_user_can_list_non_system_purchase_order_templates(): void
    {
        StoreEmailTemplate::factory()->count(5)->create([
            'type' => StoreEmailTemplate::TYPE_CONTEXT_PURCHASE_ORDER,
            'is_system_template' => false
        ]);

        $response = $this->getJson(route('store-email-templates.user-templates'))->assertOk();

        $this->assertCount(5, $response->json('data'));
    }

    public function test_user_can_send_sales_order_to_customer(): void
    {
        $salesOrder    = SalesOrder::factory()->create();
        $emailTemplate = StoreEmailTemplate::factory()->create([
            'type' => StoreEmailTemplate::TYPE_CONTEXT_SALES_ORDER,
            'is_system_template' => false
        ]);

        $this->postJson(route('store-email-templates.send'), [
            'order_type' => 'SalesOrder',
            'order_id' => $salesOrder->id,
            'subject' => $emailTemplate->subject,
            'html_body' => $emailTemplate->html_body,
        ])->assertOk();
    }

    public function test_user_can_send_purchase_order_to_supplier(): void
    {
        $purchaseOrder = PurchaseOrder::factory()->create();
        $emailTemplate = StoreEmailTemplate::factory()->create([
            'type' => StoreEmailTemplate::TYPE_CONTEXT_PURCHASE_ORDER,
            'is_system_template' => false
        ]);

        $this->postJson(route('store-email-templates.send'), [
            'order_type' => 'PurchaseOrder',
            'order_id' => $purchaseOrder->id,
            'subject' => $emailTemplate->subject,
            'html_body' => $emailTemplate->html_body,
        ])->assertOk();
    }
}