<?php

namespace Tests\Feature\Controllers;

use App\Models\SalesOrder;
use App\Models\SalesOrderLine;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class SalesOrderLineFinancialControllerTest extends TestCase
{
    use FastRefreshDatabase;

    public function test_index(): void
    {
        Sanctum::actingAs(User::factory()->create(['is_power_user' => 1]));

        SalesOrder::factory()
            ->has(SalesOrderLine::factory()->count(3))
            ->create();

        $response = $this->getJson('api/financials/sales-order-lines');

        $response->assertJsonStructure([
            'data' => [
                '*' => [
                    'id',
                    'sales_order' => [
                        'id',
                        'order_number',
                    ],
                    'order_date',
                    'customer' => [
                        'id',
                        'name',
                    ],
                    'created_at',
                    'updated_at',
                ],
            ],
        ]);
    }
}
