<?php

namespace Tests\Feature\Controllers;

use App\Exceptions\PurchaseOrder\NotOpenPurchaseOrderException;
use App\Exceptions\PurchaseOrder\ReceivePurchaseOrderLineException;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\Concerns\UseSimpleSkuFactories;
use Tests\TestCase;

class PurchaseOrderShipmentControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use UseSimpleSkuFactories;

    protected function setUp(): void
    {
        parent::setUp();
        Sanctum::actingAs(User::first());
    }

    /**
     * @throws NotOpenPurchaseOrderException
     * @throws ReceivePurchaseOrderLineException
     */
    public function testItCanDeleteReceipts()
    {
        $this->setUpWarehouse();
        $this->setUpProduct();
        $purchaseOrder = $this->setUpPurchaseOrders(3)->first();
        $purchaseOrderLine = $purchaseOrder->purchaseOrderLines->first();

        $purchaseOrderShipmentReceipt1 = $this->receivePurchaseOrder($purchaseOrder, 2);
        $purchaseOrderShipmentReceipt2 = $this->receivePurchaseOrder($purchaseOrder, 1);
        $purchaseOrderLine->unreceived_quantity = 0;

        $this->delete(route('purchase-order-shipments.delete-receipt', $purchaseOrderShipmentReceipt1))->assertOk();

        $purchaseOrderLine->refresh();
        $this->assertEquals(2, $purchaseOrderLine->unreceived_quantity);

    }
}
