<?php

namespace Tests\Feature\Controllers;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\Product;
use App\Models\ProductListing;
use App\Models\Shopify\ShopifyProduct as ShopifyProductAlias;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class ProductListingControllerTest extends TestCase
{
    use FastRefreshDatabase;

    public function test_it_can_show_product_listing(): void
    {
        Sanctum::actingAs(User::first());

        $shopifyIntegration = Integration::whereName('shopify')->first();

        /** @var IntegrationInstance $shopifyIntegrationInstance */
        $shopifyIntegrationInstance = IntegrationInstance::factory(1, ['integration_id' => $shopifyIntegration->id])
            ->hasSalesChannel()
            ->create()
            ->first();
        $shopifyIntegrationInstance->refresh();

        $product = Product::factory()->create();
        $shopifyProduct = ShopifyProductAlias::factory()->create(['integration_instance_id' => $shopifyIntegrationInstance->id]);

        $productListing = ProductListing::factory()->create([
            'product_id' => $product->id,
            'sales_channel_id' => $shopifyIntegrationInstance->salesChannel->id,
            'document_id' => $shopifyProduct->id,
            'document_type' => ShopifyProductAlias::class,
        ])->first();

        $response = $this->getJson(route('product-listings.show', ['product_listing' => $productListing]));

        $response->assertStatus(200);
    }
}
