<?php

namespace Tests\Feature\Controllers;

use App\Data\NoteData;
use App\Models\Note;
use App\Models\Product;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class NoteControllerTest extends TestCase
{
    use WithFaker, FastRefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        Sanctum::actingAs(User::first());
    }

    public function test_it_can_create_a_note(): void
    {
        $product = Product::factory()->create();
        $note    = $this->faker()->sentence();

        $this->post(route('notes.store'), NoteData::from([
                'note' => $note,
                'link_id' => $product->id,
                'link_type' => Product::class,
        ])->toArray())->assertOk();

        $this->assertDatabaseHas((new Note())->getTable(), [
            'note' => $note
        ]);
    }

    public function test_it_can_delete_a_note(): void
    {
        $product = Product::factory()->create();
        $userId = User::first()->id;
        $note = Note::factory()->create([
            'link_id' => $product->id,
            'link_type' => Product::class ,
            'user_id' => $product->$userId
        ]);

        $this->delete(route('notes.destroy', [
            'link_type' => Product::class,
            'link_id' => $product->id,
            'note' => $note->id
        ]))->assertOk();

        $this->assertDatabaseMissing('notes', ['id' => $note->id]);
    }
}