<?php

namespace Tests\Feature\Controllers;

use App\Helpers;
use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\Product;
use App\Models\ProductListing;
use App\Models\Shopify\ShopifyProduct as ShopifyProductAlias;
use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class IntegrationInstanceListingControllerTest extends TestCase
{
    use FastRefreshDatabase;

    public function test_it_can_filter_listings_by_product_filters()
    {
        Sanctum::actingAs(User::first());

        $shopifyIntegration = Integration::whereName('shopify')->first();

        /** @var IntegrationInstance $shopifyIntegrationInstance */
        $shopifyIntegrationInstance = IntegrationInstance::factory(1, ['integration_id' => $shopifyIntegration->id])
            ->hasSalesChannel()
            ->create()
            ->first();
        $shopifyIntegrationInstance->refresh();

        $product = Product::factory()->create(['type' => 'bundle']);
        $shopifyProduct = ShopifyProductAlias::factory()->create(['integration_instance_id' => $shopifyIntegrationInstance->id]);

        ProductListing::factory()->create([
            'product_id' => $product->id,
            'sales_channel_id' => $shopifyIntegrationInstance->salesChannel->id,
            'document_id' => $shopifyProduct->id,
            'document_type' => ShopifyProductAlias::class,
        ])->first();

        $response = $this->get(route('integration-instances.listings', ['integration_instance' => $shopifyIntegrationInstance]).'?'.
            Helpers::simpleFilter('product_type', 'bundle')
        )->assertOk();

        $data = $response->json()['data'];
        $this->assertCount(1, $data);

        $response = $this->get(route('integration-instances.listings', ['integration_instance' => $shopifyIntegrationInstance]).'?'.
            Helpers::simpleFilter('product_type', 'standard')
        )->assertOk();

        $data = $response->json()['data'];
        $this->assertCount(0, $data);
    }
}
