<?php

namespace Tests\Feature\Controllers;

use App\Enums\FinancialAlertTypeEnum;
use App\Enums\FinancialLineClassificationEnum;
use App\Enums\FinancialLineProrationStrategyEnum;
use App\Models\FinancialAlert;
use App\Models\FinancialLine;
use App\Models\FinancialLineType;
use App\Models\SalesOrder;
use App\Models\User;
use App\Services\FinancialManagement\SalesOrderLineFinancialManager;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class FinancialAlertControllerTest extends TestCase
{
    use FastRefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();

        Sanctum::actingAs(User::first());

        Queue::fake();
    }

    public function test_financial_alerts_controller_test(): void
    {
        // TODO: Build frontend to do some manual testing before completing this automated test
        $this->createOrderAtALoss();

        /*
        |--------------------------------------------------------------------------
        | Process Financial Alerts
        |--------------------------------------------------------------------------
        */

        $this->postJson(route('financial-alerts.process'))->assertOk();

        $this->assertDatabaseHas(FinancialAlert::class, [
            'alert_type' => FinancialAlertTypeEnum::LOSS,
        ]);

        /*
        |--------------------------------------------------------------------------
        | Get Financial Alerts
        |--------------------------------------------------------------------------
        */

        $this->getJson(route('financial-alerts.index'))->assertOk();

        /*
        |--------------------------------------------------------------------------
        | Update Financial Alert
        |--------------------------------------------------------------------------
        */

        /*
        |--------------------------------------------------------------------------
        | Archive Financial Alert
        |--------------------------------------------------------------------------
        */

        /*
        |--------------------------------------------------------------------------
        | Export Financial Alerts
        |--------------------------------------------------------------------------
        */
    }

    private function createOrderAtALoss(): void
    {
        $salesOrder = SalesOrder::factory()->hasSalesOrderLines(1, [
            'quantity' => 1,
            'amount' => 3.00,
        ])->create();

        $financialLineType = FinancialLineType::factory()->create([
            'name' => 'Shipping Cost',
            'classification' => FinancialLineClassificationEnum::COST,
        ]);

        FinancialLine::factory()->create([
            'financial_line_type_id' => $financialLineType->id,
            'sales_order_id' => $salesOrder->id,
            'description' => 'Shipping Cost',
            'quantity' => 1,
            'amount' => 4.00,
            'proration_strategy' => FinancialLineProrationStrategyEnum::REVENUE_BASED,
            'allocate_to_products' => 1,
        ]);

        (new SalesOrderLineFinancialManager())->calculate();
    }

}