<?php

namespace Tests\Feature;

use App\Models\User;
use Database\Seeders\ImmutableData\CAZipCodes\CAZipSeeder;
use Database\Seeders\ImmutableData\USZipCodes\USZipSeeder;
use Laravel\Sanctum\Sanctum;
use Tests\TestCase;
use Tests\TestCaseOld;

/**
 * @group manual
 */
class ConstantsZipcodesTest extends TestCase
{
    public function test_it_can_get_constants_us_zipcodes(): void
    {
        (new USZipSeeder())->run();

        Sanctum::actingAs(User::factory()->create());

        $this->getJson('/api/constants/get-address/US/82710')->assertSuccessful();
    }

    public function test_it_can_get_constants_ca_zipcodes(): void
    {
        (new CAZipSeeder())->run();

        Sanctum::actingAs(User::factory()->create());

        $this->getJson('/api/constants/get-address/CA/T2R0P8')->assertSuccessful();
    }
}
