<?php
/*
 * Webhook routes
 */

use App\Http\Controllers\ShipStation\ShipStationWebhooksController as ShipStationWebhooksController;
use App\Http\Controllers\Shopify\ShopifyWebhookController as ShopifyWebhookController;
use App\Http\Controllers\Starshipit\OrderController;
use App\Http\Middleware\CheckEmptyWebhookRequestMiddleware;
use Illuminate\Support\Facades\Route;

Route::middleware(CheckEmptyWebhookRequestMiddleware::class)->group(function () {
    Route::post('shipstation', ShipStationWebhooksController::class)->name('shipstation');

    Route::post('starshipit', [OrderController::class, 'receiveTrackingByWebhook'])->name('starshipit');

    // we changed to shpfy instead of shopify because the Shopify restrict "shopify" word
    Route::prefix('shpfy')->name('shopify.')->group(function () {
        Route::any('{integration_instance}/bulk_operations/finish', [ShopifyWebhookController::class, 'bulkOperationsFinish'])->name('bulk_operations_finish');
        Route::any('{integration_instance}/inventory_item/delete', [ShopifyWebhookController::class, 'inventoryItemDelete'])->name('inventory_item_delete');
        Route::any('{integration_instance}/inventory_level/update', [ShopifyWebhookController::class, 'inventoryLevelUpdate'])->name('inventory_level_update');
        Route::any('{integration_instance}/product/create', [ShopifyWebhookController::class, 'productCreate'])->name('product_create');
        Route::any('{integration_instance}/product/update', [ShopifyWebhookController::class, 'productUpdate'])->name('product_update');
        Route::any('{integration_instance}/order/create', [ShopifyWebhookController::class, 'orderCreate'])->name('order_create');
        Route::any('{integration_instance}/order/updated', [ShopifyWebhookController::class, 'orderUpdated'])->name('order_updated');
        Route::any('{integration_instance}/order_transaction/create', [ShopifyWebhookController::class, 'orderTransactionCreate'])->name('order_transaction_create');
    });

});