<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1">

      <!-- CSRF Token -->
      <meta name="csrf-token" content="{{ csrf_token() }}">

      <title>{{ config('app.name', 'Laravel') }}</title>

      <!-- Scripts -->
      <script src="{{ asset('js/app.js') }}" defer></script>

      <!-- Fonts -->
      <link rel="dns-prefetch" href="//fonts.gstatic.com">
      <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

      <!-- Styles -->
      <link href="{{ asset('css/app.css') }}" rel="stylesheet">
      <script>
        const $ = id => document.getElementById(id)

        let next = null

        const showAlertMessage = (text, type, time = 8000) => {
          const alert = document.getElementById('sku-alert')
          alert.classList.remove('alert-hidden')
          alert.classList.add(type)
          alert.innerText = text
          setTimeout(() => {
            alert.classList.remove(type)
            alert.classList.add('alert-hidden')
          }, time)
        }

        const redirect = (url) => {
          top.location.href = url;
        }

        const parseErrorMessages = (err) => {
          return err.reduce((acc, item) => {
            let message = null
            if (typeof item === 'string') message = item
            if (typeof item === 'object' && item !== null && item.hasOwnProperty('message')) message = item.message
            if (message) acc += `<strong>${message}</strong><br>`
            return acc
          }, '')
        }

        let receive = (http) => {
          let response = JSON.parse(http.response)
          if(response) {
            showAlertMessage(response.message, 'success')
            if (next) {
              setTimeout(() => {
                redirect(next)
              }, 2000)
            }
          }
        }

        let changed = (event) => {
          let xhttp = event.currentTarget
          if(xhttp.readyState == 4 && xhttp.status == 200) {
            receive(xhttp, event)
          } else if(xhttp.readyState == 4) {
            error(xhttp)
          }
        }

        let sendRequest = ( url, payload ) => {
          let xhttp = new XMLHttpRequest()
          xhttp.onreadystatechange = changed
          xhttp.open('POST', url)
          xhttp.setRequestHeader('Accept', 'application/json')
          xhttp.setRequestHeader('Content-type', 'application/json')
          xhttp.send(JSON.stringify(payload))
        }

        const setTitle = () => {
          const APP_HOST_PREFIXES = [ 'beta', 'staging', 'dev' ]
          const APP_LOCALHOST = [ 'localhost', '127.0.0.1' ]
          const host = top.location.hostname
          const hostPrefix = host.split('.')[0] || null

          if (!APP_LOCALHOST.includes(host) && (hostPrefix && !APP_HOST_PREFIXES.includes(hostPrefix))) return
          let titlePrefix = APP_LOCALHOST.includes(host) ? '(local)' : `(${hostPrefix})`

          const titleNode = document.querySelector('title')
          titleNode.innerText = `${titlePrefix} ${titleNode.innerText}`
        }
        setTitle()

      </script>
  </head>
  <body>
    <div id="app">
      <main class="container-wrapper">
        @component('alert')
        @endcomponent
        @yield('content')
      </main>
    </div>
  </body>
</html>
