<?php

return [

    /*
  |--------------------------------------------------------------------------
  | Response Status
  |--------------------------------------------------------------------------
  */

    'status_failure' => 'failure',
    'status_success' => 'success',
    'status_warning' => 'warning',

    /*
  |--------------------------------------------------------------------------
  | General Success Messages
  |--------------------------------------------------------------------------
  */

    'success' => [
        'create' => 'The :resource created successfully',
        'update' => 'The :resource \':id\' updated successfully',
        'delete' => 'The :resource :id deleted successfully',
        'restore' => 'The deleted :resource \':id\' restored successfully',
        'archive' => 'The :resource \':id\' archived successfully',
        'unarchived' => 'The :resource \':id\' unarchived successfully',
        'default' => 'The :resource \':id\' set as default successfully',
        'import' => 'The :resource imported successfully',
        'store_image' => 'The image uploaded successfully on the server',
        'delete_image' => 'The image removed successfully from the server',
        'bulk_delete' => ':success_count from :total_count :resource had been deleted successfully',
        'bulk_archive' => ':success_count/:total_count :resource had been archived successfully',
        'bulk_create' => ':success_count/:total_count :resource had been created successfully',
        'bulk_deletables' => 'products with the possibility of deletion',
        'bulk_un_archive' => ':success_count/:total_count :resource had been un archived successfully',
        'bulk_update' => 'The :resources updated successfully',
        'bulk_so_fulfill' => 'All fulfillable sales orders fulfilled successfully',
        'bulk_so_approve' => 'Sales orders approved successfully',
        'bulk_po_approve' => 'Purchase orders approved successfully',
        'bulk_po_submit' => 'Purchase orders submitted successfully',
        'open' => 'The :resource opened successfully',
        'draft' => 'The :resource was put in draft mode successfully',
        'unmapped' => 'The :resource :id unmapped successfully',
        'queued' => 'Added to the Queue, it will be processed shortly',
        'download' => 'The :resource downloaded successfully',
    ],

    /*
  |--------------------------------------------------------------------------
  | General Errors Messages
  |--------------------------------------------------------------------------
  */
    'errors' => [
        'unauthorized' => 'Unauthorized',
        'forbidden' => 'This action is unauthorized for you.',
        'jwt_key_missing' => 'JWT_SECRET missing from the .env file.',
        'not_found_http' => 'No route found for this url.',
    ],

    /*
  |--------------------------------------------------------------------------
  | General Failed Messages
  |--------------------------------------------------------------------------
  */

    'failed' => [
        'already_archive' => 'The :resource \':id\' is already archived',
        'already_exists' => 'The :resource already exists',
        'unarchived' => 'The :resource \':id\' is already unarchived',
        'restore' => 'Unexpected error, please contact with our support',
        'import_failed' => 'Unexpected error with import, please contact our support team.',
        'model_not_importable' => 'Resource :model is not importable.',
        'csv_incorrect_format' => 'CSV format is incorrect..',
        'csv_no_records' => 'No records found',
        'csv_all_lines_incorrect' => 'The file read successfully but all lines has incorrect data',
        'not_both_include_exclude' => 'You can specify either included or excluded fields, but not both.',
        'delete_image' => 'Image not found on the server, please check image path',
        'related_relations' => 'Can not delete the :resource \':id\',it is linked to other relations.',
        'bulk_delete' => 'You can not delete any :resource, they are linked to other relations',
        'bulk_archive' => 'The :resource maybe already archived',
        'bulk_un_archive' => 'The :resource are already un archived',
        'bulk_so_fulfill' => 'Failed to fulfill all selected sales orders',
        'bulk_so_fulfill_empty' => 'There is no fulfillable sales order',
        'bulk_po_approve_empty' => 'There is no purchase order selected',
        'bulk_po_approve' => 'Failed to approve all selected purchase orders',
        'bulk_po_submit_empty' => 'There is no purchase order selected',
        'bulk_po_submit' => 'Failed to submit all selected purchase orders',
        'bulk_so_approve_empty' => 'There is no sales order selected',
        'bulk_so_approve' => 'Failed to approve all selected sales orders',
        'delete' => 'The :resource \':id\' linked to other relations, you may only archive it.',
        'update_api' => 'The :resource failed to update.',
        'not_found' => 'The :resource not available',
        'map_listings' => 'Can not map the listings',
        'refresh_forecasting' => 'Failed to refresh inventory forecasting.',
        'forecasting_unavailable' => 'No forecasting result is available at this point. You can refresh the forecasting to get the latest results.',
        'create_forecasting_purchase_orders' => 'Failed to create purchase orders from forecasting.',
    ],

    'currently_used' => 'There is 1 :resource associated with this :model.|There are :count :resources associated with this :model.',
    'internal_not_deletable' => 'The :model is system owned and not deletable.',
    'internal_not_updatable' => 'The :model is system owned and cannot be updated.',

    /*
  |--------------------------------------------------------------------------
  | Integration Instance Messages
  |--------------------------------------------------------------------------
  */
    'integration_instance' => [
        'unmatched_fba_inventory_movements_count' => ':count FBA inventory movement events needing to be mapped.',
        'only_available_for_amazon' => 'This is only available for Amazon Integrations.',
        'must_enter_fba_inventory_tracking_start_date' => 'You Must Enter FBA Inventory Tracking Start Date.',
        'add_request_fba_reports_to_queue' => 'Add request FBA reports to the Queue, it will be processed shortly',
        'not_integrated' => 'The system does not integrate with :integration',
        'not_shipping_provider' => 'The integration instance is not Shipping Provider',
        'can_not_submit_order' => "Can't submit order to :resource",
        'can_not_submit_tracking' => "Can't submit tracking info to :resource",
        'unfulfillable_order' => "Can't submit order to :resource, the order exists with different lines",
        'integration_does_not_support_multiple_instances' => 'The \':input\' does not support multiple instances',
        'some_listing_mappings_failed' => ":failed listings can't map",
    ],
    /*
  |--------------------------------------------------------------------------
  | Product Messages
  |--------------------------------------------------------------------------
  */

    'product' => [
        'delete_failed' => 'The product \':id\' linked to other relations, you can archived it only',
        'delete_success' => 'The product \':id\' deleted successfully, you can restore it using product sku',
        'restore_not_found' => 'The product sku not found in deleted products',
        'set_default_pricing_failed' => "Product pricing tier ':id' is archived and cannot be set as default",
        'archive_pricing_failed' => "You can't archive the default product pricing tier ':id'",
        'delete_pricing_failed' => "You can't delete the default product pricing tier ':id'",
        'invalid_main_image_url' => 'The main image url: :url failed to resolve',
        'invalid_image_url' => 'The image url: :url:index failed to resolve',
        'invalid_image_store' => 'The image failed to resolve',
        'set_default_supplier' => 'This supplier \':supplier_id\' is now the default supplier for this product \':product_id\'',
        'parent_is_variation' => 'This product \':input\':index can not be parent id for products',
        'variation_to_variation' => 'This product can not be parent id for products',
        'different_sku' => 'The sku must be unique.',
        'different_id' => 'The :attribute \':input\':index and parent id must not be the same.',
        'variant_attribute' => 'The variation attributes must have at least one variant attribute.',
        'update_images' => 'The product images updated successfully',
        'initial_stock_insufficient_fifo_layer' => 'Insufficient fifo layer quantities for used quantities on initial fifo layer.',
        'blemished_original_standard' => 'Blemished products can only be created from standard products.',
        'not_matrix' => 'The product :id is not a matrix product.',
        'insufficient_fifo_used' => 'Not enough quantity of product (:sku) :extra to make up used FIFO Layer.',
        'used_fifo_layer' => 'There is a used fifo layer on product (:sku) connected to this activity.',
    ],

    'listing' => [
        'delete_failed' => 'The listing \':id\' linked to other relations, you can archived it only',
    ],

    'supplier_product' => [
        'reset_inventory' => 'Resetting supplier inventory for the updated supplier product \':supplier_product_id\'',
        'invalid_supplier_name' => 'The supplier sku \':supplier_name\' is invalid.',
        'invalid_supplier_warehouse' => 'The warehouse \':warehouse_name\' is invalid.',
    ],

    /*
  |--------------------------------------------------------------------------
  | Sales Order Messages
  |--------------------------------------------------------------------------
  */

    'sales_order' => [

        'delete_failed' => 'You can delete draft sales orders only',
        'customer_reference_exists' => 'The customer reference must be unique on this sales channel.',
        'customer_address_required' => 'The customer address field is required when status is open.',
        'duplicate_success' => 'The sales order duplicated successfully',
        'resend_success' => 'The sales order resend successfully',
        'exchange_success' => 'The sales order exchanged successfully',
        'line_not_exists_in_order' => "The selected line ':input' does not belongs to the sales order",
        'quantity_greater_original' => "The selected quantity ':input' is greater than original quantity line",
        'line_insufficient_fifo_layer' => 'Insufficient fifo layer quantities for sale order lines',
        'approve_failed_incomplete' => 'The selected sales order is incomplete',
        'already_approved' => 'The sales order \':id\' is already approved',
        'approve_success' => 'The sales order \':id\' approved successfully',
        'ignore_address_details' => 'The additional :address details passed will be ignore',
        'is_not_belongs' => 'The sales order line does not belong to the selected sales order.',
        'payment_does_not_belong' => 'The sales order payment does not belong to the selected sales order.',
        'is_not_belongs_warehouses' => 'The warehouse id does not belong to the sales order warehouses.',
        'fully_returned_line' => 'The selected sales order line has been fully returned',
        'is_not_fulfilled' => 'The selected sales order line is not fulfilled',
        'greater_than_unreturned' => 'The selected quantity is greater than the fulfilled quantity of the sales order line.',
        'is_not_closed' => 'The selected sales order is not closed',
        'is_closed' => 'The selected sales order is closed',
        'is_not_open' => 'The selected sales order is not open',
        'is_not_draft' => 'The sales order \':id\' is not draft',
        'is_not_approved' => 'The selected sales order is not approved',
        'is_fully_paid' => 'The selected sales order has been fully paid.',
        'more_than_remaining' => 'The provided amount is more than the remaining payment on the sales order.',
        'refund_exceeds_total_paid' => 'The amount of refund exceeds the total payment on the purchase order.',
        'line_is_fulfilled' => 'The selected sales order line is fulfilled',
        'has_unmapped_lines' => 'The selected sales order has unmapped products',
        'packing_slips_not_printed' => 'Some packing slips are not printed yet, please wait.',
        'sync_failed' => 'Order could not be synched with sales channel.',

        'sales_credit' => [
            'fully_paid' => 'The selected sales credit has been fully paid',
            'is_not_product' => 'The selected sales credit line is not a product.  Only products can be returned.',
            'fully_received' => 'The selected sales credit line has been fully received',
            'greater_than_unreceived' => 'The selected quantity is greater than the returned quantity of the sales credit line.',
            'allocations_exceed_total_amount' => 'The total allocations amount exceeds the unallocated credit.',
        ],

        'mapping_shipping_methods_count' => ':salesOrdersCount orders have the :service_name shipping method. Once you map this to a sku.io shipping method, those Orders will be updated.',

        /*
    |--------------------------------------------------------------------------
    | Fulfillment Sales Orders
    |--------------------------------------------------------------------------
    */

        'no_reservation_movements' => 'Review the items On Hand, current quantity can\'t be fulfilled',
        'no_dropship_purchase_order' => 'No dropship purchase order exists for the sales order.',
        'draft_dropship_purchase_order' => 'You cannot fulfill dropship purchase orders that are in Draft mode',
        'fully_fulfilled' => 'The selected sales order line has been fully fulfilled',
        'is_backordered' => 'The selected sales order line has an unreleased backorder queue.',
        'greater_than_unfulfilled_quantity' => 'The selected quantity is greater than unfulfilled quantity of the sales order line.',
        'is_not_belongs_to_warehouse' => 'The sales order line does not belong to the selected warehouse',
        'can_not_update_dropship_po' => 'You need to update dropship purchase order manually',
        'fulfillment_not_fba' => 'The selected sales order fulfillment is not FBA',
        'fulfillment_is_not_canceled' => 'The selected sales order fulfillment is not canceled successfully.',
        'fulfillment_is_canceled' => 'The selected sales order fulfillment is canceled successfully.',
        'can_not_delete_shipped_fulfillment' => 'The :shipping_provider order marked as shipped, you can not delete shipped fulfillment order',
        'not_all_so_fulfilled' => ':success/:total sales orders had been fulfilled successfully',
        'not_all_so_approved' => ':success/:total sales orders had been approved successfully',
        'tracking_updated' => 'The tracking data of the selected fulfillments has been updated',
        'marked_as_printed' => 'The selected sales order fulfillment marked as printed successfully.',

        /*
    |--------------------------------------------------------------------------
    | Split Sales Orders
    |--------------------------------------------------------------------------
    */

        'split_availability_missing_shipping_address' => 'This sales order does not have shipping address.',
        'split_availability_coordinates_shipping_address' => 'Shipping address coordinates not recognized.',
        'split_availability_coordinates_warehouse' => 'Warehouse(:warehouse) coordinates not recognized.',
        'missing_geocode_key' => 'GOOGLE_GEOCODE_KEY missing from the .env file.',

        /*
    |--------------------------------------------------------------------------
    | Sales Order Lines
    |--------------------------------------------------------------------------
    */

        'line_marked_as_non_product' => 'The line marked as a non-product line successfully',
        'line_already_mapped' => 'The line is already mapped with a product',
        'line_mapped' => 'The line mapped with the product successfully',
    ],

    /*
  |--------------------------------------------------------------------------
  | Category Messages
  |--------------------------------------------------------------------------
  */

    'category' => [
        'reassign_products' => 'The products reassigned successfully to the new category',
        'assign_to_product' => 'The category assigned to this product successfully:extra',
        'delete_failed' => 'You can not delete a non-leaf category',
        'non-leaf_failed' => 'The selected :attribute \':input\':index is non-leaf, you cannot assign a product to a non-leaf category.',
        'name_unique' => 'The name \':input\' has already been taken by this parent category.',
    ],

    /*
  |--------------------------------------------------------------------------
  | Attribute Group Messages
  |--------------------------------------------------------------------------
  */

    'attribute_group' => [
        'assign_success' => 'The Attribute groups assigned successfully to this product',
        'delete_failed' => 'Unable to delete this attribute group \':id\', If you wish to delete it, please first remove its associations.',
        'assign_attribute_failed' => 'The selected attribute id \':input\' assigned to another attribute group, the attribute can only be assigned to one attribute group',
    ],

    /*
  |--------------------------------------------------------------------------
  | Currency Messages
  |--------------------------------------------------------------------------
  */

    'currency' => [
        'delete_failed' => "You can't delete the default currency",
        'bulk_delete_success' => 'The currencies deleted successfully',
    ],

    /*
  |--------------------------------------------------------------------------
  | Purchase Order Messages
  |--------------------------------------------------------------------------
  */

    'purchase_order' => [
        'invoice_already_issued' => 'Invoice already issued for purchase order line(#:product_id).',
        'po_number_used_by_supplier' => "The purchase order number ':input' has already been taken by this supplier.",
        'warehouse_not_belong_to_supplier' => 'The selected supplier warehouse does not belong to the supplier',
        'submit_to_supplier' => "The purchase order ':id' submitted to supplier successfully",
        'not_submitted_to_supplier' => "The purchase order ':id' could not be submitted to the supplier.",
        'email_not_exists' => 'The supplier does not have any purchase order email',
        'approved' => "The purchase order ':id' approved successfully",
        'empty_lines' => 'The purchase order does not have purchase order lines',
        'is_not_belongs' => 'The purchase order line does not belong to the selected purchase order.',
        'fully_fulfilled_line' => 'The selected purchase order line has been fully fulfilled',
        'greater_than_unfulfilled' => 'The selected quantity is greater than unfulfilled quantity of the purchase order line.',
        'fully_invoiced_line' => 'The selected purchase order line has been fully invoiced',
        'greater_than_uninvoiced' => 'The selected quantity is greater than uninvoiced quantity of the purchase order line.',
        'dropship_purchase_order' => "The purchase order ':id' is linked as dropship with a sales order",
        'used_fifo_layers_in_lines' => "The purchase order ':id' has fifo layers (fulfilled) linked with it's lines",
        'fully_shipped' => 'The purchase order is fully shipped.',
        'fully_received' => 'The purchase order is fully received.',
        'is_not_open' => 'The purchase order must be open.',
        'required_store' => 'The store id required if supplier and setting does not have a default store.',
        'purchase_order_is_locked' => 'The selected purchase order is locked, you can\'t edit it',
        'not_associated_to_supplier' => 'The product :input is not associated to the supplier.',
        'quantity_less_than_received' => 'The updated quantity is less than the received quantity.',
        'quantity_less_than_invoiced' => 'The updated quantity is less than the invoiced quantity.',
        'can_not_delete_received_lines' => "Some lines are already received, You can't delete them",
        'can_not_delete_invoiced_lines' => "Some lines are already invoiced, You can't delete them",
        'only_draft_orders' => 'Only draft orders are valid imports.',
        'can_not_receive_lines' => 'Unable to receive purchase order lines.',
        'already_approved' => 'The purchase order \':id\' is already approved',
        'not_all_approved' => ':success/:total purchase orders had been approved successfully',
        'not_all_submitted' => ':success/:total purchase orders had been submitted successfully',
        'product_not_exists_validation' => 'The selected :attribute \':input\':index does not exist in SKU products.',

        'shipment' => [
            'is_not_belongs' => 'The purchase order shipment line does not belong to the selected purchase order shipment.',
            'fully_received_line' => 'The selected purchase order shipment line has been fully received',
            'fully_received' => 'The selected purchase order shipment has been fully received.',
            'greater_than_unreceived' => 'The selected quantity is greater than unreceived quantity of the purchase order line.',
            'completing_no_lines' => 'The purchase order has been fully shipped since no lines were provided.',
            'used_receipt_fifo_layer' => "The fifo layer on the receipt of product ':sku' is already in use.",
        ],

        'mail' => [
            'new_purchase_order' => 'New Purchase Order',
        ],
    ],

    /*
  |--------------------------------------------------------------------------
  | Warehouse Messages
  |--------------------------------------------------------------------------
  */

    'warehouse' => [
        'transfer_no_quantity' => 'Not enough quantity of product (:sku) :extra',
        'transfer_fifo_used' => 'Not enough quantity of product (:sku) :extra to make up used FIFO Layer.',
        'transfer_status_open' => 'Transfer (:transfer_id) is already open :extra',
        'transfer_status_not_open' => 'Transfer (:transfer_id) must be open :extra',
        'transfer_greater_quantity' => 'The received quantity is greater then the original warehouse transfer quantity.',
        'transfer_already_receipted' => 'Some warehouse transfers has been receipted.',
        'transfer_success' => 'The warehouse transfer receipted successfully',
        'warehouse_needs_location' => 'The selected warehouse \':input\' does not have default location',
        'transfer_no_products' => 'The warehouse transfer must have at least 1 product.',
        'non_supplier_warehouse' => 'The warehouse must not be a supplier warehouse.',
        'archived_failed' => 'The warehouse(:id) associated with an integration instance.',
        'not_archived_has_stock' => 'The warehouse (:id) has stock available and can\'t be archived.',
        'not_archived_fba' => 'The warehouse (:name) is an FBA warehouse and can\'t be archived.',
        'dropship_has_orders' => 'The warehouse (:id) has open sales orders and cannot remove dropship status.',
        'transfer_used' => "Not enough quantity of ':id' to make up used FIFO Layers for \":sku\".",
    ],

    /*
  |--------------------------------------------------------------------------
  | Supplier Messages
  |--------------------------------------------------------------------------
  */

    'supplier' => [
        'archive_pricing_failed' => "You can't archive the default supplier pricing tier ':id'",
        'set_default_pricing_failed' => "Supplier pricing tier ':id' is archived and cannot be set as default",
        'supplier_sku_exists' => 'The supplier sku \':input\':index has already been taken by this supplier.',
        'product_id_exists' => 'The product id \':input\':index has already been taken by this supplier.',
        'delete_pricing_failed' => "You can't delete the default supplier pricing tier ':id'",
        'delete_pricing_not_supplier' => 'The provided supplier does not own this pricing tier.',
        'label_unique' => 'The label \':input\':index has already been taken by this supplier.',
        'must_have_default_warehouse' => 'The selected supplier :input does not have default warehouse',
    ],

    /*
  |--------------------------------------------------------------------------
  | Inventory Messages
  |--------------------------------------------------------------------------
  */

    'inventory' => [
        'fifo_layer_existed' => 'Already initialized inventory count for this product',
        'initialized_count' => 'The inventory count initialized successfully',
        'fifo_layer_not_existed' => "Don't have enough quantity for the product(:product_sku)",
        'inventory_adjusted' => 'The inventory adjusted successfully for this product',
        'assembly_created' => 'Assembly successfully created',
        'adjustment_quantity_equals_actual' => 'The adjusted quantity equals to actual quantity of the product',
        'adjustment_quantity_not_zero' => 'The adjusted quantity cannot be zero.',
        'fulfilled_quantity_not_covered' => "The fulfilled quantity from this adjustment can't be covered from active fifo layers",
    ],

    /*
  |--------------------------------------------------------------------------
  | Stock Take Messages
  |--------------------------------------------------------------------------
  */

    'stock_take' => [
        'imported_lines_unmatched' => ':count imported lines have unmatched sku in the system',
        'negative_snapshot_inventory' => 'Some lines have negative snapshot inventory',
    ],

    /*
  |--------------------------------------------------------------------------
  | Import/Export
  |--------------------------------------------------------------------------
  */

    'import_export' => [
        'create_relation_function' => 'Must create a function for :key relation: protected function :method($model,$fields,&$row,$prefix)',
        'instance_of_model' => 'ExportExport model must be instance of Eloquent Model.',
        'mismatch_header_row' => 'The numbers of columns in header and row are not the same',
        'mismatch_template' => 'CSV file does not match our templates, please update your file to match a template and try again.',
        'tmp_file_not_exists' => 'The tmp_file \'input\' does not exists in filesystem',
        'model_not_support' => 'The model \':input\' will be supported soon.',
        'success_import' => ':success/:total :resource had been imported successfully',
        'success_export' => ':total :resource had been exported successfully',
        'failed_import_any_record' => 'All CSV file rows are invalid',
        'id_not_exists' => "ID :id doesn't exist in SKU, review file and import again.",
    ],

    /*
  |--------------------------------------------------------------------------
  | Customer Messages
  |--------------------------------------------------------------------------
  */

    'customer' => [
        'customer_exists' => 'You have this address for another customer',
        'set_default_address' => 'The address set as default :type address successfully',
        'unset_default_address' => 'The address unset from default :type address successfully',
        'label_unique' => 'The label \':input\':index has already been taken by this customer.',
        'email_exists' => 'The :input exists in other customer addresses',
    ],

    /*
  |--------------------------------------------------------------------------
  | Settings Messages
  |--------------------------------------------------------------------------
  */

    'settings' => [
        'update_nominal_code_mapping' => 'Mapping nominal codes updated successfully',
        'update_sales_orders' => 'Sales orders settings updated successfully',
        'update_purchase_orders' => 'Purchase orders settings updated successfully',
        'update_inventory_forecasting' => 'Inventory Forecasting settings updated successfully',
        'set_warehouse_priority' => 'Warehouse priority successfully set',
        'set_inventory_start_date' => 'Inventory start date successfully set',
        'inventory_start_date_not_set' => 'Inventory start date must be set in Settings.',
        'update_sku_pattern' => 'Sku pattern settings updated successfully.',
    ],

    /*
  |--------------------------------------------------------------------------
  | Nominal Code Messages
  |--------------------------------------------------------------------------
  */

    'nominal_code' => [
        'used_in_mapping' => "This nominal code ':id' is currently used by mapping",
    ],

    /*
  |--------------------------------------------------------------------------
  | Payment Terms Messages
  |--------------------------------------------------------------------------
  */

    'payment_terms' => [
        'delete_failed' => 'The payment term \':id\' linked to other relations, you can archived it only',
        'delete_success' => 'The payment term \':id\' deleted successfully, you can restore it using payment term id',
    ],

    /*
  |--------------------------------------------------------------------------
  | Store Messages
  |--------------------------------------------------------------------------
  */

    'store' => [
        'delete_local_failed' => "The store ':id' is the default local store, you can't delete it",
    ],

    /*
  |--------------------------------------------------------------------------
  | Address Messages
  |--------------------------------------------------------------------------
  */

    'address' => [
        'locked' => "The selected address is locked, you can't edit it",
    ],

    /*
  |--------------------------------------------------------------------------
  | Shipping Methods Messages
  |--------------------------------------------------------------------------
  */

    'shipping_methods' => [
        'name_unique_by_carrier' => 'The name \':input\':index has already been taken by this shipping carrier.',
        'used_in_settings' => "This shipping method ':id' is currently used by sales orders settings",
    ],

    /*
  |--------------------------------------------------------------------------
  | FIFO Layer Messages
  |--------------------------------------------------------------------------
  */
    'fifo_layer' => [
        'archive_not_fully_fulfilled' => 'The fifo layer \':id\' cannot be archived since it\'s not fully fulfilled',
    ],

    /*
  |--------------------------------------------------------------------------
  | Store Email Template Messages
  |--------------------------------------------------------------------------
  */
    'store_email_template' => [
        'empty_purchase_orders' => 'The selected supplier does not have any purchase order',
    ],

    'tax-rate' => [
        'delete_failed' => 'The tax rate \':id\' linked to other relations, you can archived it only',
        'delete_success' => 'The tax rate \':id\' deleted successfully, you can restore it using product id',
    ],

    /*
    |--------------------------------------------------------------------------
    | Data Table Alerts
    |--------------------------------------------------------------------------
    */

    'data_table_alerts' => [
        'refresh_from_external_api' => 'There are :count :items pending items refresh from :integration_name, which are downloading in the background',
    ],
];
