// const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin;
const webpack = require('webpack');
const fs = require('fs');
const doWriteToDisk = fs.existsSync('../.write-to-disk');

module.exports = {
  // output built static files to Laravel's public dir.
  // note the "build" script in package.json needs to be modified as well.
  outputDir: '../public',
  indexPath: '../resources/views/index.blade.php',
  assetsDir: 'build',
  devServer: {
    port: 8080,
    writeToDisk: doWriteToDisk,
    hot: true
  },
  lintOnSave: false,
  runtimeCompiler: true,
  configureWebpack: {
    output: {
      filename: 'build/js/[name].[id].[hash].js',
      chunkFilename: 'build/js/[name].[id].[hash].js'
    },
    optimization: {
      splitChunks: {
        chunks: 'all',
        automaticNameDelimiter: '.',
        name: (module, chunks, cacheGroupKey) => {
          const moduleFileName = module.identifier().split('/').reduceRight(item => item).replace(/\.[^/.]+$/, '')
          const allChunksNames = chunks.map((item) => item.name).join('.')
          return `${cacheGroupKey}-${moduleFileName}-${allChunksNames}`
        }
      }
    },
    plugins: [
      // new BundleAnalyzerPlugin({ openAnalyzer: false }),
      new webpack.ContextReplacementPlugin(/moment[/\\]locale$/, /en/),
      new webpack.HotModuleReplacementPlugin()
    ]
  }
}
