import formatDigit from '@/support/formatDigit'
import addCommas from '@/support/addCommas'

export default (headerValue, row, currencies) => {
  let cellValue = ''
  let valueExist = false
  let value
  let currency

  // if value has a dot splitter, than we deal with an object
  if (headerValue.indexOf('.') !== -1) {
    const objectPath = headerValue.split('.')

    if ((objectPath[0] === 'price' || objectPath[0] === 'supplier_pricing') && objectPath[2] === 'info') {
      value = row && row[objectPath[0]] && row[objectPath[0]][objectPath[1]] &&
        row[objectPath[0]][objectPath[1]].value
      currency = row && row[objectPath[0]] && row[objectPath[0]][objectPath[1]] &&
        row[objectPath[0]][objectPath[1]].currency

      valueExist = Boolean(value && currency)

      if (valueExist) {
        let currencySymbol = '$'
        if (currencies) {
          let wanted = currencies.find(i => i.code === currency)
          if (wanted && wanted.symbol) currencySymbol = wanted.symbol
        }
        cellValue = `${currencySymbol}${addCommas(formatDigit(value))} ${currency}`
      }
    } else if (objectPath[0] === 'price' || objectPath[0] === 'supplier_pricing') {
      valueExist = Boolean(row && row[objectPath[0]] && row[objectPath[0]][objectPath[1]] && row[objectPath[0]][objectPath[1]][objectPath[2]])
      if (valueExist) {
        value = row[objectPath[0]][objectPath[1]][objectPath[2]]
        if (objectPath[2] === 'value') {
          cellValue = formatDigit(Number(value)) // addCommas(formatDigit(value)) Causing some prices to be NaN
        } else {
          cellValue = value
        }
      }
    } else if (objectPath[0] === 'attributes') {
      valueExist = Boolean(row && row.attributes && row.attributes[objectPath[1]] && row.attributes[objectPath[1]].value)
      if (valueExist) cellValue = row.attributes[objectPath[1]].value
    } else if (objectPath[0] === 'inventory') {
      valueExist = Boolean(row && row.inventory && row.inventory[objectPath[1]])
      if (valueExist) cellValue = row.inventory[objectPath[1]].inventory_total
    } else if (objectPath[0] === 'inventory_available_warehouses') {
      valueExist = Boolean(row && row.inventory_available_warehouses && row.inventory_available_warehouses[objectPath[1]])
      if (valueExist) cellValue = row.inventory_available_warehouses[objectPath[1]].inventory_available
    }
  } else {
    cellValue = row[headerValue]
  }

  return cellValue
}
