import showErrors from '@/support/showErrors'
import { authQuickBooks } from '@/services/QuickBooksServices'

export default {
  data () {
    return {
      finalizing: false
    }
  },
  methods: {
    async authQuickBooksInstance (instanceId) {
      try {
        this.finalizing = true
        const { data } = await authQuickBooks(instanceId)
        if (data) window.location.href = data
      } catch (e) {
        showErrors.call(this, e)
      } finally {
        this.finalizing = false
      }
    }
  }
}
