export const getItemsRequest = async (query, commit, itemRequest, params = {}) => {
  try {
    commit('SET_LOADING', true)
    const {data,table_specifications} = await itemRequest(params,query)
    commit('SET_ITEMS_LIST', data)
    if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
  } catch (e) {
    return Promise.reject(e)
  } finally {
    commit('SET_LOADING', false)
  }
}

export const getTableMetaRequest = async (query, commit, itemRequest, params = {}) => {
  try {
    const {meta} = await itemRequest(params,query)
    if (meta?.last_page) commit('SET_MAX_PAGES', meta.last_page)
    if (meta) commit('SET_META', meta)
  } catch (e) {
    return Promise.reject(e)
  }
}

export const getTableSpecificationsRequest = async (query, commit, itemRequest, params = {}) => {
  try {
    const {table_specifications} = await itemRequest(params,query)
    if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
    return Promise.resolve()
  } catch (e) {
    return Promise.reject(e)
  }
}

export const fetchNewItem = async (commit, itemRequest, {instanceId, id}) => {
  commit('SET_LOADING_ITEM', true)
  try {
    const {data} = await itemRequest(instanceId,id)
    commit('SET_SELECTED_ITEM', data)
    return Promise.resolve()
  } catch (e) {
    throw e
  } finally {
    commit('SET_LOADING_ITEM', false)
  }
}
