import { dateIsBetween } from '@/support/timeHelper'

export const setAnalitycsData = (dateRange, data = [], dateFieldName = 'order_date') => {
  const result = {
    today: {
      current: [],
      previous: []
    },
    yesterday: {
      current: [],
      previous: []
    },
    lastWeek: {
      current: [],
      previous: []
    },
    custom: {
      current: [],
      previous: []
    }
  }

  Object.keys(dateRange).forEach(prop => {
    Object.keys(dateRange[prop]).forEach(childProp => {
      if (Array.isArray(dateRange[prop][childProp])) {
        const [start, end] = dateRange[prop][childProp]
        result[prop][childProp] = filteredByPeriod(data, start, end, dateFieldName)
      }
    })
  })
  return result
}

export const  filteredByPeriod = (data, start, end, fieldName = 'order_date') => {
  if (!data || !Array.isArray(data)) return []
  return data.filter(row => row[fieldName] && dateIsBetween(row[fieldName], start, end))
}
