
export const availableItems = (row, isDropship, destination) => {
  // destination could be warehouse or customer (in case of a dropshipping purchase order)
  if (isDropship && row.inventory) {
    // show total of all stock
    return row.inventory.total?.available || 0
  }
  // show stock for a given warehouse
  if (!destination?.name) return 0

  let destinationName = destination.name
  if (row?.inventory?.warehouses) {
    const available = row.inventory.warehouses[destinationName] !== undefined
      ? row.inventory.warehouses[destinationName].available
      : row.inventory.warehouses['all'].available
    if (available === 'in_stock') return 'In Stock'

    return Number(available) || 0
  }

  return 0
}
