import formatDigit from '@/support/formatDigit'

export const getPriceObject = (product, pricingTierName) => {
  if (product && product.pricing && pricingTierName) {
    const pricing = product.pricing.find(i => i.name === pricingTierName)
    return pricing || null
  }
  return null
}

export const getProductPrice = (product, pricingTierName) => {
  if (product && pricingTierName) {
    const priceObj = getPriceObject(product, pricingTierName)
    if (!priceObj) return ''
    return formatDigit(priceObj.value)
  }

  return ''
}

export const getProductCurrency = (product, pricingTierName, currencies) => {
  const priceObj = getPriceObject(product, pricingTierName)
  if (!priceObj) return ''

  const curencyObj = currencies.find(i => i.code === priceObj.currency)

  let currencySymbol
  if (curencyObj) currencySymbol = curencyObj.symbol

  return currencySymbol || priceObj.currency
}
