export const setLocalStorageItem = (itemName, value) => {
  const item = typeof value === 'object' ? JSON.stringify(value) : value
  localStorage.setItem(itemName, item)
}

export const localStorageService = {
  set (itemName, value) {
    const item = typeof value === 'object' ? JSON.stringify(value) : value
    localStorage.setItem(itemName, item)
  },
  get (itemName) {
    const item = localStorage.getItem(itemName)
    const numPattern = new RegExp(/^\d+$/)
    const jsonPattern = new RegExp(/[\[\{].*[\}\]]/)

    if(item){
      if(jsonPattern.test(item)){
        return JSON.parse(item)
      }
      else if(numPattern.test(item)) {
        return parseFloat(item)
      }
      return item
    }
    return null
  },
  remove (itemName) {
    localStorage.removeItem(itemName)
  },
  setToken (value) {
    this.set (KEYS.TOKEN_KEY, value)
  },
  getToken () {
    return this.get(KEYS.TOKEN_KEY)?.access_token
  },
  removeToken () {
    this.remove(KEYS.TOKEN_KEY)
  }
}

// this keys also using on login.blade.php
export const KEYS = {
  IS_EXPIRE_TOKEN: 'isExpireToken',
  TOKEN_KEY: 'SKUtoken',
  REDIRECT_TO: 'redirectTo',
  SKU_ENDPOINT: 'sku_endpoint'
}
