import { fromUserTimezoneToUtc } from '@/support/timeHelper'

export const getSettingInstancePayload = (integrationId,editedValues,startDate) => {
  return {
    integration_id: integrationId,
    name: editedValues.name,
    integration_settings: setIntegrationSettings(editedValues,startDate),
  }
}

export const getUpdatedInstancePayload = (editedValues,startDate) => {
  return {
    name: editedValues.name,
    is_automatic_sync_enabled: editedValues.is_automatic_sync_enabled,
    integration_settings: setIntegrationSettings(editedValues,startDate),
  }
}

export const setIntegrationSettings = (editedValues,startDate) => {
  return {
    url: editedValues.url,
    start_date: fromUserTimezoneToUtc(startDate),
    store_id: editedValues.store.id,
    auto_link_products: editedValues.auto_link_products,
    auto_create_products: editedValues.auto_create_products,
    sales_nominal_code_id: editedValues.sales_nominal_code_id,
    cogs_nominal_code_id: editedValues.cogs_nominal_code_id,
    emailCustomers: editedValues.emailCustomers,
    proforma_marketplace_cost_percentage: editedValues.proforma_marketplace_cost_percentage,
    proforma_payment_cost_percentage: editedValues.proforma_payment_cost_percentage,
    sync_sales_order_invoices_to_accounting: editedValues.sync_sales_order_invoices_to_accounting
  }
}
