// returns format +x (xxx) xxx-xxxx

export default (phone) => {
  if (!phone) return ''
  phone = String(phone)
  phone = phone.replace(/\D/g, '') // remove non-digits

  const x = phone.replace(/\D/g, '').match(/(\d{0,1})(\d{0,3})(\d{0,3})(\d{0,4})/)

  const one = x[1]
  const two = x[2]
  const three = x[3]
  const four = x[4]

  if (!one) return ''

  if (!two) return `+${one}`
  if (!three) return `+${one} (${two}`
  if (!four) return `+${one} (${two}) ${three}`

  return `+${one} (${two}) ${three}-${four}`
}
