import { apiModelName, humanizeStringValue } from '@/support/helpers'

export const getEnumsList = (list, context) => {
  return list.map(({ data_name, friendly_name, variable_name }, index) => {
    return {
      context,
      variable_name,
      data_name,
      friendly_name,
      order: index + 1
    }
  })
}

export const getEnumDictionary = (entities = [], variable_name) => {
  return entities.map(({data_name,friendly_name}) => ({data_name,friendly_name,variable_name}))
}

export const getModelDictionaries = (models = [], variable_name = '', customize = null) => {
  return models.map(data_name => ({ data_name, friendly_name: humanizeStringValue(apiModelName(data_name),null,customize), variable_name }))
}
