import {AMAZON_INSTANCE, API_MODELS} from '@/assets/constants'

const DRAWERS = {
  SO_FULFILLMENT: 'salesOrderFulfillmentDrawer',
  PO_INVOICE: 'purchaseInvoiceDrawer',
  PO_RECEIPT: 'purchaseReceitDrawer',
  ADJUSTMENT: 'adjustmentDrawer',
  WAREHOUSE: 'warehouseDrawer',
  PRODUCT: 'productDrawer',
  SC: 'salesCreditDrawer',
  ST: 'stockTakeDrawer',
  SO: 'salesOrderDrawer',
  PO: 'purchaseOrderDrawer',
  WAREHOUSE_TRANSFER: 'warehouseTransferDrawer',
  WAREHOUSE_TRANSFER_SHIPMENT: 'warehouseTransferDrawer',
  WAREHOUSE_TRANSFER_RECEIPT: 'warehouseTransferReceiptDrawer',
  ACCOUNTING: {
    TRANSACTION: 'accountingTransactionDrawer',
  }
}

export const openProductDrawerBySku = (vm, sku, mode = 'DashboardFinancials', hideNavigator = true) => {
  vm.$layerManager.open({ n: 'ProductDrawer', t: 'ProductDrawer', s: sku, m: mode, h: hideNavigator })
}

export const openProductDrawerById = (vm, id, mode = 'DashboardFinancials', hideNavigator = true, hash = '') => {
  let obj = { n: 'ProductDrawer', t: 'ProductDrawer', i: id, m: mode, h: hideNavigator }
  if (hash) obj.hash = hash
  vm.$layerManager.open(obj)
}

export const openInventoryPreviewDrawer = (vm, instanceId, locationId) => {
  vm.$layerManager.open({ n: 'InventoryPreviewDrawer', t: 'InventoryPreviewDrawer', i: instanceId, lId: locationId, })
}

export const openWarehouseDrawer = (vm, id, mode = 'WarehouseDashboardDetails', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'WarehouseDrawer', id: id, mode: mode, hideNavigator: hideNavigator })
}

export const openSalesOrderDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'OrderDrawer', id: id, mode: mode, hideNavigator: hideNavigator })
}

export const openSalesCreditDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'SalesCreditDrawer', id: id, mode: mode, hideNavigator: hideNavigator })
}

export const openPurchaseOrderDrawer = (vm, id, mode = 'viewPurchaseOrder', hideNavigator = true) => {
  vm.$layerManager.open({ n: 'PurchaseOrderDrawer', t: 'PurchaseOrderDrawer', i: id, m: mode, h: hideNavigator })
}

export const openReceiptDrawer = (vm, id, mode = 'edit', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'PurchaseOrderReceiptDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openInventoryAdjustmentDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'InventoryAdjustmentDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openFifoLayerDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'FifoLayerDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openWarehouseTransferDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'WarehouseTransferDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openWarehouseTransferReceiptDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'TransferReceiptDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openWarehouseTransferShipmentDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'TransferShipmentDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openInventoryAssemblyDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'InventoryAssemblyEntityDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openSupplierDrawer = (vm, id, mode = 'DashboardFinancials', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'SupplierDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openStockTakeDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'StockTakeDrawer', id, mode: mode, hideNavigator: hideNavigator })
}

export const openDataFeedDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$layerManager.open({ n: 'DataFeedDrawer', t: 'DataFeedDrawer', i: id, m: mode, h: hideNavigator })
}

export const openProductListingDrawer = (vm, id, mode = 'ListingSummary', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'ProductListingDrawer', id, mode, hideNavigator })
}

export const openSalesOrderFulfillmentDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'OrderFulfillmentDrawer', id, mode, hideNavigator })
}

export const openActivityLogDrawer = (vm, id = null, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'ActivityLogDrawer', id, mode, hideNavigator })
}

export const openPurchaseInvoiceDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'PurchaseInvoiceDrawer', id, mode, hideNavigator })
}

export const openOrderFinancialsDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'OrderFinancialsDrawer', id, mode, hideNavigator })
}

export const openSalesOrderLineDrawer = (vm, id, mode = 'view', hideNavigator = true, context = null) => {
  vm.$drawer.$emit('open', { name: 'SalesOrderLineDrawer', id, mode, hideNavigator, context })
}

export const openAmazonEventGroupDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const namespace = 'IntegrationAmazonFinancialEventGroupDrawer'
  vm.$layerManager.open({n: namespace, t: namespace, i: id, m: mode, h: hideNavigator})
}

export const openAccountingTransactionDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'AccountingTransactionDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonInboundShipmentDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonInboundShipmentDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonNewInboundShipmentDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonNewInboundShipmentDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonLedgerCustomerReturnsDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonLedgersCustomerReturnsDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonLedgerShipmentsDetailDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonLedgersShipmentsDetailDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonLedgerRemovalShipmentsDetailDrawer = (vm, id, mode = 'view', hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonLedgersRemovalShipmentsDetailDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonLedgerDrawer = (vm, id, mode = 'view', u = false,  hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonLedgerDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openAmazonLedgerSummaryDrawer = (vm, id, mode = 'view', u = false,  hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonLedgerSummaryDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}
export const openAmazonFnskuProductDrawer = (vm, id, mode = 'view', u = false,  hideNavigator = true) => {
  const drawerName = 'IntegrationAmazonFnskuProductDrawer'
  vm.$layerManager.open({ n: drawerName, t: drawerName, i: id, m: mode, h: hideNavigator })
}

export const openCustomerDrawer = (vm, id, mode = 'DashboardComponent', hideNavigator = true) => {
  vm.$drawer.$emit('open', { name: 'CustomerDrawer', id, mode, hideNavigator,})
}

// The list of excluded/unlinked resources
const unlinked = ['initial_count']
const purchaseOrderTypes = ['purchase_order', 'purchase_receipt']
const inventoryAdjustmentTypes = ['adjustment', 'inventory_adjustment']

export const openLinkedDrawer = (vm, { name, parentLinkId, linkId, type }) => {
  if (unlinked.includes(name)) return

  if (name === 'sale') {
    if (parentLinkId) { openSalesOrderDrawer(vm, parentLinkId) }
  } else if (purchaseOrderTypes.includes(name)) {
    if (parentLinkId) { openPurchaseOrderDrawer(vm, parentLinkId) }
  } else if (inventoryAdjustmentTypes.includes(name)) {
    openInventoryAdjustmentDrawer(vm, linkId)
  } else if (name === 'fifo') {
    openFifoLayerDrawer(vm, linkId)
  } else if (name === 'transfer' || name === 'warehouse_transfer') {
    if (parentLinkId) { openWarehouseTransferDrawer(vm, parentLinkId) }
  } else if (name === 'stock_take') {
    if (parentLinkId) openStockTakeDrawer(vm, parentLinkId)
  } else if (name === 'assembly') {
    if (parentLinkId) openInventoryAssemblyDrawer(vm, parentLinkId)
  } else if (name === 'return' || name === 'sales_credit') {
    if (type === 'App\\Models\\SalesCredit' || type === 'App\Models\FifoLayer') {
      if (linkId) openSalesCreditDrawer(vm, linkId)
    } else {
      if (parentLinkId) openSalesCreditDrawer(vm, parentLinkId)
    }
  }
}

export const ACCOUNTING_TYPES = {
  stock_take: {parent: null, drawer: DRAWERS.ST},
  sales_order: {parent: null, drawer: DRAWERS.SO},
  purchase_order: {parent: null, drawer: DRAWERS.PO},
  sales_credit: {parent: null, drawer: DRAWERS.SC},
  inventory_adjustment: {parent: null, drawer: DRAWERS.ADJUSTMENT},
  sales_order_fulfillment: {parent: DRAWERS.SO, darwer: DRAWERS.SO_FULFILLMENT},
  purchase_order_receipt: {parent: DRAWERS.PO, drawer: DRAWERS.PO_RECEIPT},
  purchase_order_invoice: {parent: DRAWERS.PO, drawer: DRAWERS.PO_INVOICE},
  customer_return: {parent: DRAWERS.SC, drawer: null},
  sales_order_invoice: {parent: null, drawer: DRAWERS.SO},
  warehouse_transfer_shipment: {parent: DRAWERS.WAREHOUSE_TRANSFER, drawer: DRAWERS.WAREHOUSE_TRANSFER_SHIPMENT},
  warehouse_transfer_receipt: {parent: DRAWERS.WAREHOUSE_TRANSFER, drawer: DRAWERS.WAREHOUSE_TRANSFER_RECEIPT},
  accounting_transaction: {parent: null, drawer: DRAWERS.ACCOUNTING.TRANSACTION},
}

export const openDrawerByAccountingType = (vm, {name, link_id, parent_id}, isBlockedParent = false) => {
  if (!Object.keys(ACCOUNTING_TYPES).includes(name)){
    console.warn(`accounting type: ${name}, doesn't found`)
    return
  }

  Object.keys(ACCOUNTING_TYPES[name]).forEach(key => {
    const isActiveDrawer = key === 'parent' ? !isBlockedParent : true
    if (isActiveDrawer) {
      const id = key === 'parent' && parent_id ? parent_id : link_id
      const drawer = ACCOUNTING_TYPES[name][key]
      if (drawer) vm.$nextTick(() => {
        openDrawerByType(vm, drawer, id)
      })
    }
  })
}

export const openDrawerByType = (vm, name, id) => {
  if (!name || !id) return

  switch (name) {
    case DRAWERS.SO:
      openSalesOrderDrawer(vm, id)
    break
    case DRAWERS.SO_FULFILLMENT:
      openSalesOrderFulfillmentDrawer(vm, id)
    break
    case DRAWERS.PO:
      openPurchaseOrderDrawer(vm, id)
    break
    case DRAWERS.PO_RECEIPT:
      openReceiptDrawer(vm, id)
    break
    case DRAWERS.PO_INVOICE:
      openPurchaseInvoiceDrawer(vm, id)
    break
    case DRAWERS.SC:
      openSalesCreditDrawer(vm, id)
    break
    case DRAWERS.ST:
      openStockTakeDrawer(vm, id)
    break
    case DRAWERS.ADJUSTMENT:
      openInventoryAdjustmentDrawer(vm, id)
    break
    case DRAWERS.ACCOUNTING.TRANSACTION:
      openAccountingTransactionDrawer(vm, id)
    break
    case DRAWERS.WAREHOUSE_TRANSFER:
      openWarehouseTransferDrawer(vm, id)
    break
    default:
      console.warn(`accounting type: ${name}, doesn't found`)
  }
}

const amazonDetailReportableDrawers = {
  [AMAZON_INSTANCE.ENTITIES.FBA.REPORT_SHIPMENT]: openAmazonLedgerShipmentsDetailDrawer,
  [AMAZON_INSTANCE.ENTITIES.FBA.REPORT_CUSTOMER]: openAmazonLedgerCustomerReturnsDrawer,
  [AMAZON_INSTANCE.ENTITIES.FBA.REPORT_REMOVAL_SHIPMENT]: openAmazonLedgerRemovalShipmentsDetailDrawer,
}

export const openAmazonDetailReportDrawers = (vm, {type,id}) => {
  openDrawersByKey(vm, {id, key:type, list:amazonDetailReportableDrawers, })
}

export const openDrawersByKey = (vm, {key,id,list}) => {
  const openDrawerFn = list[key]
  if (typeof openDrawerFn !== 'function') return
  openDrawerFn(vm, id)
}

export const API_MODEL_DRAWERS = {
  [API_MODELS.STOCK_TAKE]: openStockTakeDrawer,
  [API_MODELS.SALES_CREDIT]: openSalesCreditDrawer,
  [API_MODELS.INVENTORY_ADJUSTMENT]: openInventoryAdjustmentDrawer,
  [API_MODELS.PURCHASE_ORDER]: openPurchaseOrderDrawer,
  [API_MODELS.WAREHOUSE_TRANSFER]: openWarehouseTransferDrawer,
  [API_MODELS.SALES_ORDER_FULFILLMENT]: openSalesOrderFulfillmentDrawer,
  [API_MODELS.PURCHASE_ORDER_RECEIPT]: openReceiptDrawer,
  [API_MODELS.PRODUCT]: openProductDrawerById,
  [API_MODELS.SALES_CREDIT]: openSalesCreditDrawer,
  [API_MODELS.WAREHOUSE_TRANSFER_RECEIPT]: openWarehouseTransferReceiptDrawer,
  [API_MODELS.WAREHOUSE_TRANSFER_SHIPMENT]: openWarehouseTransferShipmentDrawer,
  [API_MODELS.INVENTORY_ASSEMBLY]: openInventoryAssemblyDrawer,
  [API_MODELS.STOCK_TAKE]: openStockTakeDrawer,
  [API_MODELS.SALES_ORDER]: openSalesOrderDrawer,
}

export const openDarwerByModelName = function (vm, {type,id}) {
  openDrawersByKey(vm, { type, id, list:API_MODEL_DRAWERS, })
}

export const openDrawerByModelPath = function (vm, path, id) {
  API_MODEL_DRAWERS[path](vm, id)
}
