export default ({
  visibleOnly,
  included,
  total,
  limit,
  filters,
  sortObjs,
  page,
  query,
  specifications,
  archived,
  cancelToken,
  ...params
} = {}, formatAsObject = true) => {
  let constructedQuery
  if (params && Object.keys(params).length) params
  if (formatAsObject) {
    constructedQuery = {}

    if (limit) constructedQuery.limit = limit
    if (filters) constructedQuery.filters = filters
    if (sortObjs) constructedQuery.sortObjs = sortObjs
    if (page) constructedQuery.page = page
    if (query) constructedQuery.query = query
    // 0 = data without specifications/totals/archived, 1 = only specifications, 2 = data + specifications/totals/archived
    constructedQuery.table_specifications = specifications || '0'
    constructedQuery.total = total || '0'
    constructedQuery.archived = archived || '0'
    constructedQuery.visible_only = visibleOnly || '0'

    if (included && included.length) constructedQuery.included = included
    
    return {params: {...constructedQuery, ...params}, cancelToken}
  }
  constructedQuery = '?'

  if (limit) constructedQuery = constructedQuery.concat(`limit=${limit}`)
  if (filters) constructedQuery = constructedQuery.concat(`&filters=${filters}`)
  if (sortObjs) constructedQuery = constructedQuery.concat(`&sortObjs=${sortObjs}`)
  if (page) constructedQuery = constructedQuery.concat(`&page=${page}`)
  if (query) constructedQuery = constructedQuery.concat(`&query=${query}`)
  // 0 = data without specifications/totals/archived, 1 = only specifications, 2 = data + specifications/totals/archived
  constructedQuery = constructedQuery.concat(`&table_specifications=${specifications || '0'}`)
  constructedQuery = constructedQuery.concat(`&total=${total || '0'}`)
  constructedQuery = constructedQuery.concat(`&archived=${archived || '0'}`)
  constructedQuery = constructedQuery.concat(`&visible_only=${visibleOnly || '0'}`)

  Object.keys(params).forEach(prop => {
    constructedQuery = constructedQuery.concat(`&${prop}=${params[prop]}`)
  })

  if (included && included.length) constructedQuery = constructedQuery.concat(`&included=${included}`)

  return constructedQuery
}
