const CtxClass = window.audioContext || window.AudioContext || window.AudioContext || window.webkitAudioContext
const ctx = new CtxClass()

export default (duration, type) => {
  duration = +duration
  // Only 0-4 are valid types.
  type = (type % 5) || 0

  const osc = ctx.createOscillator()
  osc.type = type

  osc.connect(ctx.destination)
  if (osc.noteOn) osc.noteOn(0) // old browsers
  if (osc.start) osc.start() // new browsers

  setTimeout(() => {
    if (osc.noteOff) osc.noteOff(0) // old browsers
    if (osc.stop) osc.stop() // new browsers
  }, duration)
}
