export const showDeleteConfirmationModal = (vm, name, source = 'delete-reason') => {
  openConfirmModal(
      vm,
      source,
      `Are you sure you want to delete these accounting transactions?`
  )
}

export const showDeletePaymentsConfirmationModal = (vm, name, source = 'delete-payments-reason') => {
  openConfirmModal(
    vm,
    source,
    `Deleted payments will lose any reconciliation work. Are you sure you want to delete ${name} payments?`
  )
}

export const showUnlinkConfirmationModal = (vm, source = 'unlink-reason') => {
  openConfirmModal(
    vm,
    source,
    'Are you sure you want to unlink this accounting transaction from the integration?'
  )
}

const openConfirmModal = (vm, source, message) => {
  vm.$confirm.$emit('open', {
    source,
    message: `
      <div class="p-3 pb-5 rounded-sm bg-orange-200">
        ${message}
      </div>
    `
  })
}
