const EVENTS = {
  reloadInventoryAdjustment: [
    'inventoryBreakdownReload',
    'salesOrderDrawerReload',
  ],
  reloadStockTake: [
    'inventoryStockTakesReload',
  ],
  reloadSalesOrder: [
    'productDashboardInventorySalesReload',
  ],
  reloadWarehouseTransfer: [
    'inventoryWarehouseTransfersReload',
    'dashboardInventoryWarehouseTransfersReload',
  ],
  reloadPurchaseOrder: [
    'dashboardInventoryPurchaseHistoryReload',
    'purchaseOrdersReload',
    'purchaseReceiptReload',
    'purchaseOrderActivityReload',
  ],
  reloadFilteringSalesOrder: [
    'salesOrderFilteringViewReload',
  ],
}

export function UpdateManager (Vue) {

  this.emit = function (vm, eventName, value = null) {
    if (!EVENTS.hasOwnProperty(eventName)) {
      console.error(`event (${eventName}) not found`)
      return
    }
    EVENTS[eventName].forEach(event => {
      if (value) vm.$update.$emit(event, value)
      else vm.$update.$emit(event)
    })
  }
}

export default {
  install (Vue) {
    Vue.prototype.$updateManager = Vue.observable(new UpdateManager(Vue))
  }
}
