import { fetchWarehouseMappings, fetchShipstationWarehouses, mapShipstationWarehouse, deleteShipstationWarehouseMapping } from '@/services/shipstation/ShipstationService'

export const IntegrationShipstationInstanceModule = {
  namespaced: true,
  state: () => ({
    warehouseMappingsLoading: false,
    warehouseMappings: [],
    shipstationWarehousesLoading: false,
    shipstationWarehouses: [],
    saveLoading: false
  }),
  getters: {
    getWarehouseMappingsLoading: state => state.warehouseMappingsLoading,
    getWarehouseMappings: state => state.warehouseMappings,
    getShipstationWarehousesLoading: state => state.shipstationWarehousesLoading,
    getShipstationWarehouses: state => state.shipstationWarehouses
  },
  mutations: {
    SET_WAREHOUSE_MAPPINGS_LOADING (state, value) {
      state.warehouseMappingsLoading = value
    },
    SET_WAREHOUSE_MAPPINGS (state, value) {
      state.warehouseMappings = value
    },
    SET_SHIPSTATION_WAREHOUSES_LOADING (state, value) {
      state.shipstationWarehousesLoading = value
    },
    SET_SHIPSTATION_WAREHOUSES (state, value) {
      state.shipstationWarehouses = value
    },
    SET_SAVE_LOADING (state, value) {
      state.saveLoading = value
    }
  },
  actions: {
    async fetchWarehouseMappings ({ commit }) {
      commit('SET_WAREHOUSE_MAPPINGS_LOADING', true)
      try {
        const { data } = await fetchWarehouseMappings()
        commit('SET_WAREHOUSE_MAPPINGS', data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_WAREHOUSE_MAPPINGS_LOADING', false)
      }
    },
    async fetchShipstationWarehouses ({ commit }) {
      commit('SET_SHIPSTATION_WAREHOUSES_LOADING', true)
      try {
        const { data } = await fetchShipstationWarehouses()
        commit('SET_SHIPSTATION_WAREHOUSES', data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_SHIPSTATION_WAREHOUSES_LOADING', false)
      }
    },
    async saveWarehouseMapping ({ commit, dispatch }, { sendData }) {
      commit('SET_SAVE_LOADING', true)
      try {
        await mapShipstationWarehouse({ mapping: [sendData] })
        dispatch('fetchWarehouseMappings')
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_SAVE_LOADING', false)
      }
    },
    async deleteWarehouseMapping ({ commit, dispatch }, { ids }) {
      commit('SET_SAVE_LOADING', true)
      try {
        await deleteShipstationWarehouseMapping({ ids: [ids] })
        dispatch('fetchWarehouseMappings')
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_SAVE_LOADING', false)
      }
    }
  }
}
