import { fetchFinancialLineTypes } from '@/services/financials/FinancialLineTypeService'
import { FINANCIALS } from '@/assets/constants'

const {REVENUE,COST} = FINANCIALS.LINES.CLASSIFICATIONS

export const FinancialLineTypesModule = {
  namespaced: true,
  state: {
    loading: false,
    items: [],
  },
  getters: {
    getFinancialLineTypes: state => state.items,
    getLoading: state => state.loading,
    getRevenueTypes: (_,getters) => getters.getFinancialLineTypes.filter(t => t.classification === REVENUE),
    getCostTypes: (_,getters) => getters.getFinancialLineTypes.filter(t => t.classification === COST),
  },
  mutations: {
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_TYPES (state, value) {
      state.items = value 
    },
  },
  actions: {
    async fetchFinancialLineTypes ({commit}, payload = null) {
      commit('SET_LOADING', true)
      try {
        const data = await fetchFinancialLineTypes(payload)
        if (data) commit('SET_TYPES', data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_LOADING', false)
      }
    },
  }
}