import { fetchAmazonInboundShipmentById } from '@/services/AmazonIntegrationInboundService'

export const IntegrationAmazonShipmentsModule = {
  namespaced: true,
  state: () => ({
    loading: false,
    drawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false,
      mode: null, // view
    },
    selectedItem: {},
  }),
  getters: {
    getLoading: state => state.loading,
    getSelectedItem: state => state.selectedItem,
    getDrawerMode: state => state.drawer.mode,
    getDrawerShow: state => state.drawer.show,
    getDrawerHideNavigator: state => state.drawer.hideNavigator,
  },
  mutations: {
    SET_LOADING (state,value) {
      state.loading = value
    },
    SET_SELECTED_ITEM (state,value) {
      state.selectedItem = value
    },
  },
  actions: {
    async fetchNewItem ({ commit }, {instanceId, id}) {
      commit('SET_LOADING',true)
      try {
        const {data} = await fetchAmazonInboundShipmentById(instanceId, id)
        if (data) commit('SET_SELECTED_ITEM',data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING',false)
      }
    },
  }
}
