import { fetchFinancesSettlementTypeMappings } from '@/services/AmazonIntegrationFinancesService'

export const IntegrationAmazonFinancialSettlementMappingTypesModule = {
  namespaced: true,
  state: () => ({
    mappings: [],
    loading: false,
    instanceId: null,
  }),
  getters: {
    getMappings: state => state.mappings,
    getLoading: state => state.loading,
    getInstanceId: state => state.instanceId,
  },
  mutations: {
    SET_MAPPINGS (state, value) {
      state.mappings = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    },
    SET_INSTANCE_ID (state, value) {
      state.instanceId = value
    },
  },
  actions: {
    async fetchMappings ({ commit }, instanceId) {
      try {
        commit('SET_LOADING', true)
        const { data } = await fetchFinancesSettlementTypeMappings(instanceId)
        commit('SET_MAPPINGS', data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
  }
}
