import { fetchFinancesEventGroupById,fetchFinancesSettlementData } from '@/services/AmazonIntegrationFinancesService'

export const IntegrationAmazonFinancialEventGroupModule = {
  namespaced: true,
  state: () => ({
    loading: false,
    drawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false,
      mode: 'view', // view
    },
    selectedItem: null,
    settlements: [],
    loadingSettlements: false,
  }),
  getters: {
    getLoading: state => state.loading,
    getSelectedItem: state => state.selectedItem,
    getDrawerMode: state => state.drawer.mode,
    getDrawerShow: state => state.drawer.show,
    getDrawerHideNavigator: state => state.drawer.hideNavigator,
    getSettlements: state => state.settlements.map(row => {
      if (row.posted_date_time.search('UTC') !== -1) {
        const [date, time] = row.posted_date_time.split(' ')
        const [h,m] = time.split(':')
        row.posted_date_time = `${date}T${h}:${m}:10Z`
      }
      return row
    }),
    getLoadingSettlements: state => state.loadingSettlements,
  },
  mutations: {
    SET_LOADING (state,value) {
      state.loading = value
    },
    SET_SELECTED_ITEM (state,value) {
      state.selectedItem = value
    },
    SET_SETTLEMENTS (state,value) {
      state.settlements = value
    },
    SET_LOADING_SETTLEMENTS (state,value) {
      state.loadingSettlements = value
    },
  },
  actions: {
    async fetchNewItem ({ commit }, {instanceId, id}) {
      commit('SET_LOADING',true)
      try {
        const {data} = await fetchFinancesEventGroupById(instanceId, id)
        if (data) commit('SET_SELECTED_ITEM',data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING',false)
      }
    },
    async fetchSettlements ({commit}, {instanceId, query}) {
      commit('SET_LOADING_SETTLEMENTS',true)
      try {
        const {data} = await fetchFinancesSettlementData(instanceId, query)
        if (data) commit('SET_SETTLEMENTS',data)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING_SETTLEMENTS',false)
      }
    }, 
  }
}
