export const WizardModule = {
  namespaced: true,
  state: {
    completedSteps: {
      channelStep: false,
      salesBrandChannelStep: false,
      templateStep: false,
      suppliersStep: false
    },
    isWizardDone: false
  },
  getters: {
    completedSteps: state => state.completedSteps,
    isWizardDone: state => state.isWizardDone
  },
  mutations: {
    SET_COMPLETED_STEP (state, { step, done }) {
      state.completedSteps[step] = done
    },
    // Set isWizardDone to true when user has finished it
    SET_WIZARD_DONE (state) {
      state.isWizardDone = true
    }
  },
  actions: {
    setCompletedStep ({ commit }, { step, done }) {
      commit('SET_COMPLETED_STEP', { step, done })
    },
    // Set wizard done action
    setWizardDone ({ commit }) {
      commit('SET_WIZARD_DONE')
    }
  }
}
