import { fetchWarehouses, getWarehouseByID, updateWarehouse } from '@/services/WarehousesService'
import Vue from 'vue'

const compactWarehouses = (item) => ({id:item.id, text: item.name})

export const WarehousesModule = {
  namespaced: true,
  state: {
    editWarehouseNotificationId: 'warehouse-edit-detail',
    warehousesLoading: false,
    itemsList: [],
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    selectedWarehouse: {},
    editedWarehouse: null,
    drawerMode: null,
    isWarehouseEditing: false,
    userWarehouses: {
      itemsList: [],
      loading: false,
      tableSpecifications: {},
      maxPages: 0,
      meta: {}
    },
    notFbaWarehouses: [],

    warehouseDrawer: {
      show: false,
      hideNavigator: false,
      initialItemId: false
    },

    dashboardData: {
      loading: false,
      analytics: null,
    }
  },
  getters: {
    getWarehousesLoading: state => state.warehousesLoading,
    getItemsList: state => state.itemsList,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getSelectedWarehouse: state => state.selectedWarehouse,
    getEditedWarehouse: state => state.editedWarehouse,
    getSelectedWarehouseIndex: state => {
      if (!state.selectedWarehouse || !state.userWarehouses.itemsList.length) { return -1 }
      return state.userWarehouses.itemsList.findIndex(i => i.id === state.selectedWarehouse.id)
    },
    getDrawerMode: state => state.drawerMode,
    getIsWarehouseEditing: state => state.isWarehouseEditing,
    getEditNotificationId: state => state.editWarehouseNotificationId,

    getUserWarehousesItems: state => state.userWarehouses.itemsList,
    getUserWarehousesLoading: state => state.userWarehouses.loading,
    getUserWarehousesSpecs: state => state.userWarehouses.tableSpecifications,
    getUserWarehousesMaxPages: state => state.userWarehouses.maxPages,
    getUserWarehousesMeta: state => state.userWarehouses.meta,

    getWarehouseDrawer: state => state.warehouseDrawer,
    getDashboardAnalytics: state => state.dashboardData.analytics,
    getDashboardLoading: state => state.dashboardData.loading,
    getNotFbaWarehouses: state => state.notFbaWarehouses,
    getWarehousesByType: state => type => state.itemsList.reduce((acc,item) => {
      if (item.type === type) acc = [...acc, compactWarehouses(item)]
      return acc
    },[]),
    getSupplierWarehouses: state => state.itemsList.reduce((acc,item) => {
      if (item.supplier) acc = [...acc, compactWarehouses(item)]
      return acc
    },[]),
    getNonSupplierWarehouse: state => state.itemsList.reduce((acc, item) => {
      if (!item?.supplier) acc = [...acc, compactWarehouses(item)]
      return acc
    },[]),
  },
  mutations: {
    SET_WAREHOUSES_LOADING (state, value) {
      state.warehousesLoading = value
    },
    // Set selected warehouse mutation
    SET_SELECTED_WAREHOUSE (state, warehouse) {
      state.selectedWarehouse = Object.assign({}, warehouse)
    },
    // Set selected warehouse mutation
    SET_EDITED_WAREHOUSE (state, warehouse) {
      state.editedWarehouse = Object.assign({}, warehouse)
    },
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_DRAWER_MODE (state, value) {
      state.drawerMode = value
    },
    SET_WAREHOUSE_EDITING (state, value) {
      state.isWarehouseEditing = value
    },
    SET_USER_WAREHOUSES_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.userWarehouses, field, value)
    },

    SET_WAREHOUSE_DRAWER_FIELD (state, { field, value }) {
      Vue.prototype.$set(state.warehouseDrawer, field, value)
    },
    SET_DASHBOARD_DATA (state, {field,value}) {
      Vue.prototype.$set(state.dashboardData, field, value)
    },
    SET_NOT_FBA_WAREHOUSES (state, value) {
      state.notFbaWarehouses = value
    },
  },
  actions: {
    async setSelectedWarehouse ({ commit }, ID) {
      if (ID === null) {
        commit('SET_SELECTED_WAREHOUSE', null)
        return
      }
      commit('SET_WAREHOUSES_LOADING', true)
      const response = await getWarehouseByID(ID)

      commit('SET_SELECTED_WAREHOUSE', response.data)

      commit('SET_WAREHOUSES_LOADING', false)
    },
    async getItemsRequest ({ commit }, query) {
      query.exclude_supplier_warehouses = 0
      try {
        commit('SET_WAREHOUSES_LOADING', true)
        const response = await fetchWarehouses(query)

        commit('SET_ITEMS_LIST', response.data)
        if (response.table_specifications) commit('SET_TABLE_SPECIFICATIONS', response.table_specifications)
      } catch (e) {
        throw e
      } finally {
        commit('SET_WAREHOUSES_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      query.exclude_supplier_warehouses = 0
      try {
        commit('SET_WAREHOUSES_LOADING', true)
        const response = await fetchWarehouses(query)
        if (response.meta && response.meta.last_page) commit('SET_MAX_PAGES', response.meta.last_page)
        if (response.meta) commit('SET_META', response.meta)
      } catch (e) {
        throw e
      } finally {
        commit('SET_WAREHOUSES_LOADING', false)
      }
    },
    async fetchUserWarehouses ({ commit }, query = {}) {
      query.exclude_supplier_warehouses = 1
      try {
        commit('SET_USER_WAREHOUSES_FIELD', { field: 'loading', value: true })
        const response = await fetchWarehouses(query)

        commit('SET_USER_WAREHOUSES_FIELD', { field: 'itemsList', value: response.data })
        if (response.table_specifications) commit('SET_USER_WAREHOUSES_FIELD', { field: 'tableSpecifications', value: response.table_specifications })
      } catch (e) {
        throw e
      } finally {
        commit('SET_USER_WAREHOUSES_FIELD', { field: 'loading', value: false })
      }
    },
    async fetchUserWarehousesMeta ({ commit }, query) {
      query.exclude_supplier_warehouses = 1
      try {
        const response = await fetchWarehouses(query)
        if (response.meta && response.meta.last_page) commit('SET_USER_WAREHOUSES_FIELD', { field: 'maxPages', value: response.meta.last_page })
        if (response.meta) commit('SET_USER_WAREHOUSES_FIELD', { field: 'meta', value: response.meta })
      } catch (e) {
        throw e
      }
    },
    async loadUserWarehouseTableSpecifications ({ commit }, query) {
      try {
        const response = await fetchWarehouses(query)

        if (response.data?.table_specifications) commit('SET_USER_WAREHOUSES_FIELD', { field: 'tableSpecifications', value: response.data.table_specifications })
        return Promise.resolve()
      } catch (e) {
        throw e
      }
    },
    async updateWarehouse ({ commit, state, getters }, { ID, data }) {
      try {
        commit('SET_WAREHOUSES_LOADING', true)
        const response = await updateWarehouse(ID, data)
        commit('SET_SELECTED_WAREHOUSE', response.data)
        state.itemsList[getters.getSelectedWarehouseIndex] = response.data
      } catch (e) {
        throw e
      } finally {
        commit('SET_WAREHOUSES_LOADING', false)
        commit('SET_WAREHOUSE_EDITING', false)
      }
    },
    async fetchNotFbaWarehouses ({commit}, included = []) {
      const filters = {
        conjunction: 'and',
        filterSet: [{
          column: 'type',
          operator: '!=',
          value: 'amazon_fba'
        }]
      }
      const query = {
        limit: -1,
        exclude_supplier_warehouses: 1,
        included: JSON.stringify(included),
        filters: JSON.stringify(filters)
      }
      try {
        commit('SET_WAREHOUSES_LOADING', true)
        const {data} = await fetchWarehouses(query)

        commit('SET_NOT_FBA_WAREHOUSES', data)
      } catch (e) {
        throw e
      } finally {
        commit('SET_WAREHOUSES_LOADING', false)
      }
    }
  }
}
