import {
  getTaxRates,
  createTaxRate
} from '@/services/TaxRatesService'

export const TaxRatesModule = {
  namespaced: true,
  state: {
    tableSpecifications: {},
    maxPages: 0,
    meta: {},
    loading: false,

    taxRates: [],
    firstTaxRateItemName: 'not taxable'
  },
  getters: {
    getItemsList: state => state.taxRates,
    getTableSpecifications: state => state.tableSpecifications,
    getMaxPages: state => state.maxPages,
    getMeta: state => state.meta,
    getLoading: state => state.loading,
    getTaxRates: state => state.taxRates
      .sort((a, b) => a.name.toLowerCase() === state.firstTaxRateItemName && b.name.toLowerCase() !== state.firstTaxRateItemName ? -1 : 1)
      .map(rate => ({ rate: rate.rate.toString(), id: rate.id, name: rate.name, complex_name: `${rate.rate}% - ${rate.name}` })),
    getTaxById: (_, getters) => (id) => {
      if (!id) return null
      return getters.getTaxRates.find(rate => rate.id === id)
    },
    getTaxNameById: (_, getters) => (id, propName = 'complex_name') => {
      if (!id) return null
      const rate = getters.getTaxById(id)
      return rate ? rate[propName] : null
    }
  },
  mutations: {
    SET_TAX_RATES (state, value) {
      state.taxRates = value
    },
    SET_ITEMS_LIST (state, value) {
      state.itemsList = value
    },
    SET_TABLE_SPECIFICATIONS (state, value) {
      state.tableSpecifications = value
    },
    SET_MAX_PAGES (state, value) {
      state.maxPages = value
    },
    SET_META (state, value) {
      state.meta = value
    },
    SET_LOADING (state, value) {
      state.loading = value
    }
  },
  actions: {
    async getItemsRequest ({ commit }, query) {
      try {
        commit('SET_LOADING', true)
        const { data, table_specifications } = await getTaxRates(query)
        if (data) commit('SET_TAX_RATES', data)
        if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async getMetaRequest ({ commit }, query) {
      try {
        const { meta } = await getTaxRates(query)
        if (meta?.last_page) commit('SET_MAX_PAGES', meta.last_page)
        if (meta) commit('SET_META', meta)
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const { table_specifications } = await getTaxRates(query)
        if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
        return Promise.resolve()
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async addNewItem ({ commit, getters }, query) {
      try {
        commit('SET_LOADING', true)
        const { data } = await createTaxRate(query)
        if (data?.id) commit('SET_TAX_RATES', [data, ...getters.getItemsList])
        return Promise.resolve()
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    },
    async loadTableSpecifications ({ commit }, query) {
      try {
        const { table_specifications } = await getTaxRates(query)
        if (table_specifications) commit('SET_TABLE_SPECIFICATIONS', table_specifications)
        return Promise.resolve()
      } catch (e) {
        return Promise.reject(e)
      }
    },
    async addNewItem ({ commit, getters }, query) {
      try {
        commit('SET_LOADING', true)
        const { data } = await createTaxRate(query)
        if (data?.id) commit('SET_TAX_RATES', [data, ...getters.getItemsList])
        return Promise.resolve()
      } catch (e) {
        return Promise.reject(e)
      } finally {
        commit('SET_LOADING', false)
      }
    }
  }
}
